// Arduino Uno
// Geocaching-Koordinatenanzeige mit 7-Segment-Anzeige


// Zeichenkette mit gewünschten GPS-Koordinaten
// falls das Grad-Symbol ° nicht korrekt ausgewertet wird, kann alternativ ein Stern * verwendet werden
unsigned char gc_coord[] = "N48°51.493' E002°17.670'";


// LED-Muster für 7-Segmentanzeige
unsigned char led[] = 
{ 
// 0     1     2     3     4     5     6     7     8     9     Blank N     E     S     W     °     '     Blank
   0xF6, 0x24, 0x97, 0xB5, 0x65, 0xF1, 0xF3, 0x34, 0xF7, 0xF5, 0x00, 0x76, 0xD3, 0xF1, 0xE6, 0x55, 0x04, 0x00
};


// Anzeige eines ASCII-Zeichens auf der 7-Segment-Anzeige
// Verfügbare Zeichen: N, S, E, W, Ziffern 0 bis 9, ° (Grad, kann alternativ als Stern * angegeben werden), ' (Winkelminuten), Leerzeichen
// c: ASCII-Zeichen
// dp: 0=kein Dezimalpunkt, 0x08=Dezimalpunkt zusätzlich aktivieren
void show_char(unsigned char c, unsigned char dp)
{
  unsigned char value = 10; // Blank
  
  if( (c >= '0') && (c <= '9') )
  {
    value = c - '0';
  }
  else
  {
    switch(c)
    {
      case ' ': // Leerzeichen
        value = 10;
      break;

      case 'N':
        value = 11;
      break;

      case 'E':
        value = 12;
      break;

      case 'S':
        value = 13;
      break;

      case 'W':
        value = 14;
      break;

      case '°':
      case '*':
      case 0xB0: // ° Gradsymbol
        value = 15;
      break;

      case '\'': // ' Winkelminuten
        value = 16;
      break;
    } 
  }
  PORTD = led[value] | dp; // Dezimalpunkt aktivieren falls gewünscht
  PORTB = led[value] | dp;
}


void setup()
{
   PORTD = 0;  // Ports für 7-Segment-Anzeige initialisieren
   DDRD = 0xFC;
   PORTB = 0;
   DDRB = 0x03; 
}


void loop()
{
   unsigned char i, dp;
   
   for(i = 0; i < sizeof(gc_coord); i++)  // Schleife über Zeichenkette gc_coord
   {
      if(gc_coord[i] == 0xC2)
      { // Das Grad-Symbol ° in der Zeichenkette wird als 2 Zeichen 0xC2 0xB0 im Speicher abgelegt, das erste Zeichen 0xC2 wird übersprungen
        i++;
      }
     
      if(gc_coord[i+1] == '.')
      {
        dp = 0x08;  // Wenn das nächste Zeichen ein Punkt ist, dann wird der Dezimalpunkt beim aktuellen Zeichen eingeblendet
      }
      else
      {
        dp = 0;
      }
      show_char(gc_coord[i], dp); // Zeichen ausgeben
      if(dp != 0)
      {
        i++;       // Wenn ein Dezimalpunkt eingeblendet wurde, dann muss das nächste Zeichen übersprungen werden
      }
      delay(700);  // Anzeigedauer des Zeichens in ms
      show_char(' ', 0); // Leerzeichen für Pause ausgegeben
      delay(100);  // Pause zwischen zwei Zeichen in ms, Anzeige ist aus
   }
   show_char(' ', 0);
   delay(2000);    // Pause in ms nach der kompletten Darstellung der Koordinaten
}

