#pragma once

#include "ofMain.h"
#include "ofxRPiCameraVideoGrabber.h"

class AquariumMonitor : public ofBaseApp {
  public:
    void setup();
    void update();
    void draw();

    void keyPressed(int key);
    void keyReleased(int key) {};
    void mouseMoved(int x, int y) {};
    void mouseDragged(int x, int y, int button) {};
    void mousePressed(int x, int y, int button) {};
    void mouseReleased(int x, int y, int button) {};
    void windowResized(int w, int h) {};
    void dragEvent(ofDragInfo dragInfo) {};
    void gotMessage(ofMessage msg) {};

  private:
    ofxRPiCameraVideoGrabber _pi_cam;
    ofFbo _fbo;
    ofPixels _frame;
    ofTrueTypeFont _verdana;
    ofTrueTypeFont _mono;
    char _current_temp[10];
    unsigned long long _elapsed_time;
    bool _show_info;
    int _screen_counter;

    void get_temperature();
    void show_info();
    ofPixels& getPixels();
};

