import processing.serial.*;

import controlP5.*;
ControlP5 controlP5; 

final int rate = 38400;
final int off_x = 75;
final int off_y = 70;
final int sz = 22;
final int frameX = 18;
final int frameY = 18;
final int frameLen = frameX * frameY;

Serial port;
int[] frame;
int serialCounter;
int nextFrameTime;
int framePeriod = 50;
int contrast =400;



void setup()
{
  size( 550, 550 ); 
  frameRate(3);
  frame = new int[frameLen];
  initSerial();
  nextFrameTime = millis();
  controlP5 = new ControlP5(this);
  controlP5.addSlider("Kontrast",0,1023,contrast,20,500,500,20);
}

void draw()
{
  if( millis() >= nextFrameTime )
  {
    requestFrame();
   
    background(245);

    for( int x = 1; x < 18; x++ )
      {
      for (int y = 1; y < 18; y++)  
        {
      fill( map(frame[(18*x)-y], 0, 63, 0, contrast) );
      rect( x * sz, y * sz, sz, sz);
        }
      }    
    nextFrameTime = millis() + framePeriod;
  }
}


void initSerial()
{
  String portName = Serial.list()[0];
  //String portName = "/dev/ttyACM0";
  port = new Serial(this, portName, rate);
  println("Using " + portName + " as serial device.");
}

void requestFrame()
{
  port.write('d');
  int incoming;
  int count=0; 
  do
  {
    incoming = port.read();
    frame[count] = incoming;
    count++;
   }
  while (count != 324); 
}

void controlEvent(ControlEvent theEvent) {
  if(theEvent.isController()) 
  {
    if(theEvent.controller().name()=="Kontrast")
    {
      contrast=int(theEvent.controller().value());
    }
  }
}


