// Die Wire-Bibliothek ist für die DS1307 RTC notwendig
#include "Wire.h"
// Der Hex-Wert 0x68 dient der Kommunikation mit der RTC über den I2C-Bus.
#define DS1307_I2C_ADDRESS 0x68

int leftMeter    =  9; // Linke  Anzeige (Stunden) an Arduino Pin  9 (PWM)
int rightMeter   = 10; // Rechte Anzeige (Minuten) an Arduino Pin 10 (PWM)

// Umrechnung von Dezimal zu BCD und umgekehrt,
// notwendig für die setDate()- und getDate()-Methoden.
byte decToBcd( byte val)
{ return ( ( val/10*16) + ( val%10));
}
 
byte bcdToDec( byte val)
{ return ( ( val/16*10) + ( val%16) );
}

// Initialisiere die RTC (uns interessieren nur Stunden und Minuten).
void setDateDs1307( byte second,        // 0 bis 59
                    byte minute,        // 0 bis 59
                    byte hour,          // 1 bis 23
                    byte dayOfWeek,     // 1 bis 7
                    byte dayOfMonth,    // 1 - 28/29/30/31
                    byte month,         // 1 - 12
                    byte year)          // 0 - 99
{ Wire.beginTransmission( DS1307_I2C_ADDRESS);
  Wire.write( 0);
  Wire.write( decToBcd( second));    
  Wire.write( decToBcd( minute));
  Wire.write( decToBcd( hour));  
  Wire.write( decToBcd( dayOfWeek));
  Wire.write( decToBcd( dayOfMonth));
  Wire.write( decToBcd( month));
  Wire.write( decToBcd( year));
  Wire.endTransmission();
}

// Lese Uhrzeit/Datum der RTC 
void getDateDs1307( byte *second,
                    byte *minute,
                    byte *hour,
                    byte *dayOfWeek,
                    byte *dayOfMonth,
                    byte *month,
                    byte *year)
{ Wire.beginTransmission( DS1307_I2C_ADDRESS);
  Wire.write( 0);
  Wire.endTransmission();
  Wire.requestFrom( DS1307_I2C_ADDRESS, 7); // 7-Bit Adresse
 
  // Die Bitmasken sind für Control-Bits notwendig,
  // siehe dazu das Datenblatt:
  // http://datasheets.maximintegrated.com/en/ds/DS1307.pdf
  // Alternativ kann man auch den Code aus dem Github-Repository von Watterott einsehen:
  // https://github.com/watterott/Arduino-Libs/blob/master/DS1307/DS1307.cpp
  *second     = bcdToDec( Wire.read() & 0x7f);
  *minute     = bcdToDec( Wire.read());
  *hour       = bcdToDec( Wire.read() & 0x3f);  
  *dayOfWeek  = bcdToDec( Wire.read());
  *dayOfMonth = bcdToDec( Wire.read());
  *month      = bcdToDec( Wire.read());
  *year       = bcdToDec( Wire.read());
}
 
void setup()
{ // Kommunikation mit der RTC über I2C
  Wire.begin();
  
  // Geschwindigkeit der seriellen Kommunikation (optional)
  Serial.begin( 9600);
  
  // setze Uhrzeit der RTC: 
  // hier muss der Bastler später die aktuelle Uhrzeit eintragen
  setDateDs1307( 0, 22, 14, 0, 0, 0, 0);
  
  // lege PWM-Ausgabe für die zwei Messinstrumente fest
  pinMode( leftMeter,  OUTPUT);       
  pinMode( rightMeter, OUTPUT);
  
  // Das Auspendeln der Meter ist optional.
  digitalWrite( leftMeter,  HIGH);   
  digitalWrite( rightMeter, HIGH);
  delay( 1000);
  
  digitalWrite( leftMeter,  LOW);
  digitalWrite( rightMeter, LOW);
  delay( 1000);
}
 
void loop()
{ // analogWrite( leftMeter,  leftLevel);  
  // analogWrite( rightMeter, rightLevel); 
 
  byte second, minute, hour, dayOfWeek, dayOfMonth, month, year;
 
  // lese Uhrzeit aus
  getDateDs1307( &second, &minute, &hour, &dayOfWeek, &dayOfMonth, &month, &year);
  
  // Uhrzeit wird auch am Rechner ausgegeben (optional), daher der Serial.begin() in setup()
  Serial.print( hour, DEC);
  Serial.print( ":");
  Serial.print( minute, DEC);
  Serial.print( ":");
  Serial.println( second, DEC);
  
  // Anzeige der Stunden
  if ( hour ==  0 || hour == 12) analogWrite( leftMeter, 122);  // 255 
  if ( hour ==  1 || hour == 13) analogWrite( leftMeter,  10);  // 0
  if ( hour ==  2 || hour == 14) analogWrite( leftMeter,  20);  // 29 
  if ( hour ==  3 || hour == 15) analogWrite( leftMeter,  31);  // 52 
  if ( hour ==  4 || hour == 16) analogWrite( leftMeter,  41);  // 78 
  if ( hour ==  5 || hour == 17) analogWrite( leftMeter,  51);  // 104
  if ( hour ==  6 || hour == 18) analogWrite( leftMeter,  61);  // 130
  if ( hour ==  7 || hour == 19) analogWrite( leftMeter,  71);  // 156
  if ( hour ==  8 || hour == 20) analogWrite( leftMeter,  82);  // 175
  if ( hour ==  9 || hour == 21) analogWrite( leftMeter,  92);  // 193
  if ( hour == 10 || hour == 22) analogWrite( leftMeter, 102 ); // 213
  if ( hour == 11 || hour == 23) analogWrite( leftMeter, 112);  // 234
  
  // Anzeige der Minuten:
  // Das PWM-Signal enthält einen Wert zwischen 0 und 255: 4.25 * 60 = 255
  // if ( minutes * 4.25 < 255) analogWrite( rightMeter, minutes * 4.25);   
  
  // Das Meter aus dem Versuchsaufbau besitzt eine Skala von 0 bis 100,
  // aber nur 5 x 5 := 25 Positionen.
  // if ( minutes * 10.2 < 255) analogWrite( rightMeter, minutes * 10.2);
  
  // Jeweils 5 Werte entsprechen 20 uA, 5 / 20 := 0,25. Das entspricht einer Minute
  // für den Skalenbereich von 0-60 auf dem Meter.
  if ( minute * 10.2 * 0.25 < 255) analogWrite( rightMeter, minute * 10.2 * 0.25);  
  else analogWrite( rightMeter, 255);
 
  // 1 Sekunde Pause
  delay( 1000);
}
