/* 
Das Beispielprogramm, dass es unter dem Link unten zum runter laden bereit steht, 
zeigt wie man zwei Sensoren und drei Servos einigermaßen parallel laufen lassen kann.
Der Grundtakt von 15 ms wurde gewählt, da die Servos damit gut angesteuert werden 
können. Mithilfe der Funktion millis() wird die Programmlaufzeit ständig  abgefragt.
Alle Funktionen, die nicht alle 15 ms ausgeführt werden sollen bekommen einen Zähler,
der soweit inkrementiert wird, bis die Funktion wieder ausgeführt werden soll. Zu 
Beginn der Funktion werden dann erst mal die Programmlaufzeit und der Zähler 
verglichen und die Funktion nur ausgeführt, wenn der die Laufzeit den Zähler 
schon erreicht hat.  

Der PIR-Bewegungssensor weckt den Roboter auf, solange sich in einer Umgebung von 
~7m etwas bewegt. Dann  fängt er an mit den Augen zu klimpern und den Kopf zu 
drehen. Währenddessen analysiert der Ultraschallsensor, ob jemand näher herankommt.
Wenn jemand näher als 1 m kommt wendet er den Kopf in diese Richtung.

by Friederike Maier 
CC-SA 4.0 international license 
http://creativecommons.org/licenses/by-sa/4.0/
*/
#include <Servo.h> 

#define triggerPin 8 //Ultraschall Trigger
#define echoPin 9  //Ultraschall Echo
#define ledPin 13
#define inputPin 2 //Input vom PIR Sensor

Servo myservo_b1;  // Servo blinzel 1 
Servo myservo_b2;  //Servo blinzel 2
Servo myservo_d1; // Servo zum Kopf drehen


int pos = 0;   //Servo Position b1 und b2
int lastPos;
int val; //PIR Output, ob sich was bewegt
int x; //Wie oft blinzelt der Roboter
int ledStatus = LOW; // die LED ist erstmal aus
long PIRnextWakeUp;
long nextBlinzel;
long USnextWakeUp;
int wait=15; //minimal wait time needed for servos
long zeit, abstand;
int minAbstand = 100;


int headPos;
int inc;
int pos1;


void setup() {
  pinMode(ledPin, OUTPUT); // declare the ledPin as as OUTPUT
  Serial.begin(9600);       // use the serial port
  myservo_b1.attach(10);  // attaches the servo on pin 9 to the servo object 
  myservo_b2.attach(11);
  myservo_d1.attach(6);
  pinMode(inputPin, INPUT); // der Pin für den PIR-Sensor wird als Input definiert
  pinMode(triggerPin, OUTPUT);
  pinMode(echoPin, INPUT);
  headPos=0;
  pos1=0;
}

void loop() {
  long currentTime = millis(); //millis() gibt die Programmlaufzeit in Millisekunden zurück
  int val = getPIR(currentTime);
  blinzel(currentTime,val); 
  getAbstand(currentTime);
  int headPos = moveHead(currentTime, abstand,val, inc);
  if (headPos==180) {   
    inc=-1;
  }
  if (headPos==0) {
    inc=1;
  }
  delay(wait);
}


int getPIR(unsigned long cTime){
  if(cTime>PIRnextWakeUp){
    val = digitalRead(inputPin); 
    return val;
    PIRnextWakeUp=cTime+ 100;
  }
}
 

void blinzel(unsigned long cTime, int value){
  if (cTime>nextBlinzel){
     if (value == 1) { // wenn ein ein Signal da ist
      Serial.println("*************klimper************* ");
      digitalWrite(ledPin, HIGH); // geht die LED an
      for (x = 0; x < 3; x +=1){
        for(pos = 20; pos>=4; pos-=2){                                
          myservo_b1.write(pos-6);//die Werte hier müssen je nach Augen und Einbauart der Servos kalibriert werden              
          myservo_b2.write(pos-2);
          delay(15);//hier ist ein delay ausnahmsweise ok, wenn der roboter mit den augen klimpert passiert nichts anderes      
        } 
        for(pos = 4; pos < 20; pos += 2){                                 
          myservo_b1.write(pos-6);     
          myservo_b2.write(pos-2);
          delay(15);                     
        } 
      }
      nextBlinzel=cTime +2000; //nicht zu oft blinzeln 
    }
    else {
      digitalWrite(ledPin, LOW);
    }
  } 
}  

void getAbstand(unsigned long cTime){
  if(cTime>USnextWakeUp){
   digitalWrite(triggerPin, LOW); 
   delayMicroseconds(2); 
   digitalWrite(triggerPin, HIGH); 
   delayMicroseconds(10); 
   digitalWrite(triggerPin, LOW);
   zeit = pulseIn(echoPin, HIGH); 
   abstand = zeit/58.3;
   USnextWakeUp=cTime+60; //warte 60 ms bis zum nächsten auslesen
  }
}

int moveHead(long cTime, int abstand, int value, int incr){
    if(abstand >= minAbstand && value ==1) { 
       lastPos= pos1;
       pos1=lastPos+incr;
       myservo_d1.write(pos1);            
     }
     return pos1; 
}

