#include <Adafruit_GFX.h>
#include <Adafruit_SharpMem.h>
#include <SoftwareSerial.h>

// soft serial link to BLE module, not used in this example
SoftwareSerial blueIOT(6, 9); 

//Hardware pin definitions
int UVOUT = A0; //Output from the sensor
int REF_3V3 = A1; //3.3V power on the Arduino board

//using the „soft“ SPI to interact with the Dispaly in parallel to the SPI 3D sensor, which uses the hard SPI

#define SCK 2

#define MOSI 5

#define SS 8
Adafruit_SharpMem display(SCK, MOSI, SS);

#define BLACK 0
#define WHITE 1

String inputString = "";
boolean stringComplete = false;


#define LOGO16_GLCD_HEIGHT 96 
#define LOGO16_GLCD_WIDTH  96 


void setup(void) 
{
  Serial.begin(9600);
  Serial.println("Hello!");

  blueIOT.begin(9600);

  pinMode(UVOUT, INPUT);
  pinMode(REF_3V3, INPUT);

  inputString.reserve(22);

  // start & clear the display
  display.begin();
  display.clearDisplay();
  display.refresh();
  display.setRotation(1);
  
        // text display tests
       display.clearDisplay();
       display.setTextColor(BLACK);
       
       display.setTextSize(2);
       display.setCursor(10,5);
       display.println("Burger");
       
       display.setTextSize(1);
       display.setCursor(10,25);
       display.println("Guido");
    
       display.setTextSize(4);
       display.setCursor(10,40);
       display.println("123");
  
       display.setTextSize(1);
       display.setCursor(10,75);
       display.print("C");
       display.println(GetTemp(),1);
       
       display.setTextSize(1);
       display.setCursor(50,75);
       display.print("F");
       display.println(GetTemp()*1.8+32,1);
       
       display.setTextSize(1);
       display.setCursor(10,85);
       display.print("V");
       display.println(readVcc(), DEC); 
       display.refresh();

  delay(1000);

}

void loop(void) 
{
  // Screen must be refreshed at least once per second
  delay(1000);
  
  int uvLevel = averageAnalogRead(UVOUT);
  int refLevel = readVcc()/10;
  
  //Use the 3.3V power pin as a reference to get a very accurate output value from sensor
  float outputVoltage = 3.3 / refLevel * uvLevel;
  
  float uvIntensity = mapfloat(outputVoltage, 0.99, 2.9, 0.0, 15.0);
  
  Serial.print("refV: ");
  Serial.print(refLevel);

  Serial.print(" VCC: ");
  Serial.print(readVcc()/10,DEC);

  Serial.print(" MP8511 output: ");
  Serial.print(uvLevel);

  Serial.print(" MP8511 voltage: ");
  Serial.print(outputVoltage);

  Serial.print(" UV Intensity (mW/cm^2): ");
  Serial.println(uvIntensity);
      
       display.clearDisplay();
       
       display.setTextSize(1);
       
       display.setCursor(10,10);
       display.println("SENSableTHING");
       
       display.setCursor(10,20);
       display.println("www.fab-lab.eu");
       
       display.setTextSize(1);
       display.setCursor(10,75);
       display.print("C");
       display.println(GetTemp(),1);
       
       display.setTextSize(1);
       display.setCursor(50,75);
       display.print("F");
       display.println(GetTemp()*1.8+32,1);
       
       display.setTextSize(1);
       display.setCursor(10,85);
       display.print("V");
       display.println(readVcc(), DEC); 
  
       display.setTextSize(3);
       display.setCursor(10,40);
       display.print("UV ");
       display.println(uvLevel/100); 
       display.refresh(); 
}


double GetTemp(void)
{
  unsigned int wADC;
  double t;

  // The internal temperature has to be used
  // with the internal reference of 1.1V.
  // Channel 8 can not be selected with
  // the analogRead function yet.

  // Set the internal reference and mux.
  ADMUX = (_BV(REFS1) | _BV(REFS0) | _BV(MUX3));
  ADCSRA |= _BV(ADEN);  // enable the ADC

  delay(20);            // wait for voltages to become stable.

  ADCSRA |= _BV(ADSC);  // Start the ADC

  // Detect end-of-conversion
  while (bit_is_set(ADCSRA,ADSC));

  // Reading register "ADCW" takes care of how to read ADCL and ADCH.
  wADC = ADCW;

  // The offset of 324.31 could be wrong. It is just an indication.
  t = (wADC - 324.31 ) / 1.22;

  // The returned temperature is in degrees Celcius.
  return (t);
}


long readVcc() {
   long result;   
// Read 1.1V reference against AVcc   
ADMUX = _BV(REFS0) | _BV(MUX3) | _BV(MUX2) | _BV(MUX1);   
delay(2); // Wait for Vref to settle   
ADCSRA |= _BV(ADSC); // Convert   
while (bit_is_set(ADCSRA,ADSC));   
result = ADCL;   result |= ADCH<<8;   
result = 1126400L / result; // Back-calculate AVcc in mV   
return result; } 

//Serial.println( readVcc(), DEC );   


//Takes an average of readings on a given pin
//Returns the averagevoid setup() {
  // put your setup code here, to run once:

}

void loop() {
  // put your main code here, to run repeatedly:

}
int averageAnalogRead(int pinToRead)
{
  byte numberOfReadings = 8;
  unsigned int runningValue = 0; 

  for(int x = 0 ; x < numberOfReadings ; x++)
    runningValue += analogRead(pinToRead);
  runningValue /= numberOfReadings;

  return(runningValue);  
}

//The Arduino Map function but for floats
//From: http://forum.arduino.cc/index.php?topic=3922.0
float mapfloat(float x, float in_min, float in_max, float out_min, float out_max)
{
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}
