// Reaktionstrainer

#include <LiquidCrystal.h>
const int numRows = 4; //Anzahl der Zeilen des verwendeten LCD's (Row 0, 1, 2, 3)
const int numCols = 20; //Anzahl der Spalten des verwendeten LCD's (Column 0, 1, ..., 19)
LiquidCrystal mylcd(5, 4, 3, 2, 1, 0); //Arduino Pins (Digital), die mit dem LCD Display verbunden sind

int LedNr; //Diodenummer, wird per Zufall ausgewhlt
int TastNr; //Nummer einer gedrckten Taste
long Startzeit; //Gibt Millisekunden zurck, die seit dem Programmstart vergangen sind
long Reaktionszeit; //Zeit, die zw. LED-Aufleuchten und Drcken der zugehrigen Taste vergangen ist                  
int Auswahlledpin = 12; //Arduino Pin (Digital), ber den die ausgewhlte LED mit Spannung versorgt wird
int Startledpin = 13; //Arduino Pin (Digital), ber den die Start-LED mit Spannung versorgt wird
int s0dArdPin = 9; //Arduino Pin (Digital), wird mit dem Select Input s0d des Demultiplexers verbunden
int s1dArdPin = 10; //Arduino Pin (Digital), wird mit dem Select Input s1d des Demultiplexers verbunden
int s2dArdPin = 11; //Arduino Pin (Digital), wird mit dem Select Input s2d des Demultiplexers verbunden
int s0mArdPin = 6; //Arduino Pin (Digital), wird mit dem Select Input s0m des Multiplexers verbunden
int s1mArdPin = 7; //Arduino Pin (Digital), wird mit dem Select Input s1m des Multiplexers verbunden
int s2mArdPin = 8; //Arduino Pin (Digital), wird mit dem Select Input s2m des Multiplexers verbunden


void setup()
{     
  mylcd.begin(numCols, numRows);
  mylcd.clear();
  mylcd.setCursor(0,0);
  mylcd.print("Bitte auf Start S");
  mylcd.setCursor(0,1);
  mylcd.print("druecken, dann geht");
  mylcd.setCursor(0,2);
  mylcd.print("es los!");
  
  pinMode(Auswahlledpin, OUTPUT);
  pinMode(Startledpin, OUTPUT);
  pinMode(s0dArdPin, OUTPUT);
  pinMode(s1dArdPin, OUTPUT);
  pinMode(s2dArdPin, OUTPUT);  
  pinMode(s0mArdPin, OUTPUT);
  pinMode(s1mArdPin, OUTPUT);
  pinMode(s2mArdPin, OUTPUT);  
  
  digitalWrite(Auswahlledpin, 0); //0 = LOW
  
  analogReference(DEFAULT); //Konfiguriert die Referenzspannung fr die Analogeingnge (5V fr den Arduino UNO)                     
}


void loop()
{
  int WertA2 = 0; //Wert am Analogeingang 2
  while (WertA2 < 500) //Diese Schleife wird erst verlassen, wenn die Starttaste bettigt wird
    {
      digitalWrite(Startledpin, 1); 
      WertA2 = analogRead(2);
    }
  digitalWrite(Startledpin, 0); 
 
  mylcd.clear();
  mylcd.setCursor(0,0);
  mylcd.print("Achtung, die Zeit");
  mylcd.setCursor(0,1);
  mylcd.print("vergeht!");
  mylcd.setCursor(0,2);
  mylcd.print("Konzentration!");
  
  Diodenauswahl();   //Aufruf eines Unterprogramms: ber eine Zufallszahl wird eine Diode (LedNr)ausgewhlt 
                     //und ber eine zweite Zufallszahl verzgert eingeschaltet                    
  Startzeit = millis();
    do
      {
        Tastenerkennung(); //Aufruf eines Unterprogramms: Ermittlung der Nummer einer gedrckten Taste (TastNr) 
      }
    while (LedNr != TastNr); //Diese Schleife wird erst verlassen, wenn LedNr = TastNr gilt
   
  digitalWrite(Auswahlledpin,0);
  Reaktionszeit = millis() - Startzeit; 
   
  mylcd.clear();
  mylcd.setCursor(0,0);
  mylcd.print("Die Reaktionszeit:");
  mylcd.setCursor(0,1);
  mylcd.print(Reaktionszeit);
  mylcd.print(" ms");
  mylcd.setCursor(0,2);
  if (Reaktionszeit <= 1000) {mylcd.print("Super!");}
  if ((Reaktionszeit > 1000) & (Reaktionszeit <= 1500)) {mylcd.print("Sehr gut!");}
  if ((Reaktionszeit > 1500) & (Reaktionszeit <= 2000)) {mylcd.print("Gut!");}
  if ((Reaktionszeit > 2000) & (Reaktionszeit <= 2500)) {mylcd.print("Befriedigend!");}
  if ((Reaktionszeit > 2500) & (Reaktionszeit <= 3000)) {mylcd.print("Ausreichend!");}
  if (Reaktionszeit > 3000) {mylcd.print("Weiter ueben!");}
  mylcd.setCursor(0,3);
  mylcd.print("Weiter mit Start S!");
}


void Diodenauswahl()  //Unterprogramm, wird im Hauptprogramm (void loop) aufgerufen: 
                      //ber eine Zufallszahl wird eine Diode mit Hilfe eines Demultiplexers 
                      //ausgewhlt und ber eine zweite Zufallszahl verzgert eingeschaltet.
                      //Der ausgewhlten Diode wird die Nummer LedNr zugeordnet
{    
  int s0d = 0;  //Steuersignal s0d fr den Demultiplexer (0 = LOW oder 1 = HIGH)
  int s1d = 0;  //Steuersignal s1d fr den Demultiplexer (0 = LOW oder 1 = HIGH)
  int s2d = 0;  //Steuersignal s2d fr den Demultiplexer (0 = LOW oder 1 = HIGH)
  int LedVzeit; //Zufllige Verzgerungszeit bis zum Aufleuchten einer LED
  
  randomSeed(analogRead(0)); //Damit wird der zufllige Einstieg in eine Zufallszahlenreihe ermglicht
  LedNr = random(8);  //Erzeugung einer Zufallszahl 0 oder 1 oder 2 oder ... oder 7 zur Diodenauswahl 
  randomSeed(analogRead(0)); 
  LedVzeit = 1000+ 1000*random(6); //Erzeugung einer Zufallszahl 1000 oder 2000 oder ... oder 7000 zum 
                                   //verzgertem Einschalten der gewhlten Diode 
  delay(LedVzeit);
  s0d = bitRead(LedNr,0); //s0d wird auf 0 bzw. 1 gesetzt, entsprechend der ausgewhlten Diode
  s1d = bitRead(LedNr,1); //s1d wird auf 0 bzw. 1 gesetzt, entsprechend der ausgewhlten Diode
  s2d = bitRead(LedNr,2); //s2d wird auf 0 bzw. 1 gesetzt, entsprechend der ausgewhlten Diode
  digitalWrite(s0dArdPin, s0d); //Steuersignal s0d fr den Demultiplexer
  digitalWrite(s1dArdPin, s1d); //Steuersignal s1d fr den Demultiplexer
  digitalWrite(s2dArdPin, s2d); //Steuersignal s2d fr den Demultiplexer
  digitalWrite(Auswahlledpin, 1); 
}  


void Tastenerkennung() //Unterprogramm, wird im Hauptprogramm (void loop) aufgerufen: 
                       //Ermittlung der Nummer einer gedrckten Taste (TastNr) mit
                       //Hilfe des Multiplexers 
{              
  int s0m = 0;  //Steuersignal s0m fr den Multiplexer (0 = LOW oder 1 = HIGH)
  int s1m = 0;  //Steuersignal s1m fr den Multiplexer (0 = LOW oder 1 = HIGH)
  int s2m = 0;  //Steuersignal s2m fr den Multiplexer (0 = LOW oder 1 = HIGH)
  int WertA1 = 0;  //Integerwert am Analogeingang 1
  int n = 0;
  
    while (WertA1 < 500) //Bei den Schleifendurchlufen nimmt n den Wert 0 oder 1 oder .. oder 7 an. Aus n werden Steuersignale
                         //fr den Multiplexer abgeleitet und ber analogRead(1) wird die Spannung am entsprechenden Eingang 
                         //ermittelt. Wenn Spannung vorhanden ist, bedeutet das, dass die entsprechende Taste  
                         //gdrckt ist. Dann wird die Schleife verlassen und das aktuelle n entspricht der Tastennummer.       
      { 
        s0m = bitRead(n,0); //s0m wird auf 0 bzw. 1 gesetzt, entsprechend der aktuellen Zahl n
        s1m = bitRead(n,1); //s1m wird auf 0 bzw. 1 gesetzt, entsprechend der aktuellen Zahl n
        s2m = bitRead(n,2); //s2m wird auf 0 bzw. 1 gesetzt, entsprechend der aktuellen Zahl n
        digitalWrite(s0mArdPin, s0m); //Steuersignal s0m fr den Multiplexer
        digitalWrite(s1mArdPin, s1m); //Steuersignal s1m fr den Multiplexer
        digitalWrite(s2mArdPin, s2m); //Steuersignal s2m fr den Multiplexer
        WertA1 = analogRead(1); 
        if (WertA1 >= 500) TastNr = n;
        n++;
        if (n > 7) n = 0;   
      } 
}

