#include <SoftwareSerial.h>
#include <ArduinoJson.h>

#define SSID "xzy" // SSID
#define PASS "geheim" // AP-password
#define APIKEY "thequickbrownfoxjumpsoverthelazydog"


#define LOCATIONID "Hamburg" // location id for Hamburg, Germany
#define DST_IP "api.openweathermap.org" //api.openweathermap.org

SoftwareSerial esp8266Serial(10, 11); // ESP8266 connection

void setup()
{

  Serial.begin(9600);
  esp8266Serial.begin(9600);
  esp8266Serial.setTimeout(5000);
  esp8266Serial.println("AT+RST");
  delay(2000);
  boolean connected = false;
  for (int i = 0; i < 5; i++) {
    if (connectWiFi()) {
      connected = true;
      break;
    }
  }
  if (!connected) {
    while (1);
  }
  delay(3000);
  esp8266Serial.println("AT+CIPMUX=0");
  delay(300);
}



void loop()
{
  String cmd = "AT+CIPSTART=\"TCP\",\"";
  cmd += DST_IP;
  cmd += "\",80";
  esp8266Serial.println(cmd);
  delay(300);
  if (esp8266Serial.find("Error")) return;
  cmd = "GET /data/2.5/weather?q=";
  cmd += LOCATIONID;
  cmd += "&APPID=";
  cmd += APIKEY;
  cmd += " HTTP/1.0\r\nHost: api.openweathermap.org\r\n\r\n";

  esp8266Serial.print("AT+CIPSEND=");
  esp8266Serial.println(cmd.length());
  if (esp8266Serial.find(">")) {
    Serial.println("Ready to send HTTP-Request");
  } else {
    esp8266Serial.println("AT+CIPCLOSE");
    Serial.println("Connection timeout. Sent AT+CIPCLOSE");
    delay(1000);
    return;
  }
  esp8266Serial.print(cmd);
  delay(300);
  unsigned int i = 0; //timeout counter
  int n = 1; // char counter
  char json[100] = "{";
  while (!esp8266Serial.find("\"main\":{")) {} // find the part we are interested in.
  
  delay(300);
  
  while (i < 6000) {
    if (esp8266Serial.available()) {
      char c = esp8266Serial.read();
      json[n] = c;
      if (c == '}') break;
      n++;
      i = 0;
    }
    i++;
  }
  
  StaticJsonBuffer<100> jsonBuffer;
  JsonObject& root = jsonBuffer.parseObject(json);

  double temp = root["temp"];
  int humidity = root["humidity"];
  int pressure = root["pressure"];
  temp -= 273.15; // from kelvin to degree celsius

  Serial.print("Parsing JSON data");
  Serial.println();

  Serial.print("Temperature: ");
  Serial.println(temp);
  Serial.print("Pressure: ");
  Serial.println(pressure);
  Serial.print("Humidity: ");
  Serial.println(humidity);
  Serial.println();
  
  delay(3000);
  
}


boolean connectWiFi()
{
  esp8266Serial.println("AT+CWMODE=1");
  String cmd = "AT+CWJAP=\"";
  cmd += SSID;
  cmd += "\",\"";
  cmd += PASS;
  cmd += "\"";
  esp8266Serial.println(cmd);

  delay(2000);
  if (esp8266Serial.find("OK")) {
    Serial.println("Connection established");
    return true;
  } else {
    Serial.println("Can not connect to AP");
    return false;
  }
}

