/////////////////////////////////////////////////////////////////
// POV Globe
// Ulli Schmerold
// 4/2016
// Realisiert mit Serial Peripheral Interface (SPI)
/////////////////////////////////////////////////////////////////

// SPI Pins am Arduino Nano: 10 (SS), 11 (MOSI), 12 (MISO), 13 (SCK).
// DATA_IN 12  ==> brauchen wir nicht
#define DATA_PIN  11
#define CLOCK_PIN 13
#define LATCH_PIN 10
#define Hall_PIN 2

long dauer_umlauf;        // Die Zeitdauer einer Umdrehung in Pozessortakten
byte dauer_segment;       // Speicher die Dauer von einem Segment in Pozessortakten
int aktuelles_segment=0;  // Welches Segment wird gerade gezeigt
int umdrehung = 0;        // Zählen der Umdrehungen
int dreh_position=0;      // Damit der Glob sich auch drehen kann
boolean update=false;     // Löst die Datenübertragung in die Schieberegister aus

 // Die Daten für den Globe werden im POV Globe Calculator ermittelt
 // und in einem 2 dimensionalen Array gespeichert
 // Jede Zahl(Byte) steuert 8 LEDs an
 // Ein Sektoren des Globes entsteht jeweils aus den Werten, die untereinader stehen
byte anzahl_register = 4; // Anzahl der Register
byte sectoren = 140;       // Anzahl der Sektoren pro Umlauf
byte byte_register [4][140] = {
 {0 , 3 , 7 , 7 , 7 , 7 , 7 , 7 , 7 , 7 , 3 , 3 , 3 , 3 , 3 , 3 , 3 , 3 , 3 , 3 , 3 , 7 , 7 , 7 , 7 , 7 , 7 , 3 , 3 , 3 , 3 , 2 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 32 , 96 , 96 , 112 , 124 , 126 , 255 , 255 , 255 , 255 , 124 , 120 , 56 , 56 , 16 , 0 , 0 , 0 , 0 , 0 , 1 , 1 , 0 , 0 , 0 , 3 , 3 , 3 , 7 , 6 , 12 , 8 , 14 , 14 , 15 , 15 , 11 , 11 , 11 , 3 , 3 , 7 , 7 , 7 , 7 , 7 , 7 , 15 , 15 , 15 , 31 , 15 , 7 , 15 , 15 , 15 , 31 , 31 , 63 , 63 , 63 , 63 , 63 , 127 , 127 , 127 , 63 , 31 , 31 , 31 , 31 , 31 , 31 , 15 , 15 , 15 , 15 , 15 , 15 , 30 , 30 , 30 , 30 , 14 , 14 , 13 , 13 , 12 , 14 , 14 , 14 , 14 , 12 , 12 , 12 , 12 , 4 , 0 , 0},
 {0 , 0 , 128 , 128 , 128 , 128 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 128 , 128 , 128 , 192 , 192 , 224 , 252 , 252 , 252 , 254 , 254 , 255 , 255 , 255 , 255 , 255 , 254 , 126 , 126 , 62 , 62 , 62 , 28 , 24 , 248 , 248 , 240 , 96 , 96 , 96 , 32 , 32 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 1 , 3 , 3 , 23 , 31 , 151 , 183 , 111 , 111 , 111 , 239 , 119 , 103 , 103 , 99 , 247 , 247 , 227 , 243 , 243 , 209 , 236 , 254 , 254 , 255 , 255 , 203 , 237 , 253 , 253 , 252 , 254 , 254 , 254 , 254 , 255 , 255 , 255 , 255 , 255 , 254 , 254 , 254 , 254 , 255 , 255 , 255 , 255 , 254 , 254 , 254 , 254 , 254 , 246 , 240 , 240 , 240 , 240 , 224 , 224 , 96 , 64 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 128 , 128 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0},
 {0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 128 , 192 , 192 , 64 , 64 , 64 , 96 , 32 , 38 , 30 , 31 , 31 , 31 , 31 , 31 , 15 , 15 , 15 , 15 , 7 , 7 , 7 , 3 , 3 , 2 , 0 , 0 , 0 , 0 , 0 , 0 , 128 , 192 , 192 , 192 , 192 , 192 , 192 , 192 , 192 , 192 , 224 , 240 , 254 , 255 , 255 , 255 , 255 , 255 , 255 , 255 , 252 , 252 , 240 , 96 , 225 , 67 , 4 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 128 , 192 , 192 , 32 , 0 , 0 , 0 , 0 , 0 , 0 , 128 , 128 , 128 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 1 , 1 , 1 , 3 , 3 , 3 , 1 , 1 , 1 , 1 , 1 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0},
 {0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 14 , 191 , 255 , 248 , 240 , 240 , 240 , 224 , 224 , 192 , 128 , 128 , 128 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 128 , 128 , 128 , 128 , 128 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 128 , 224 , 224 , 224 , 192 , 192 , 192 , 192 , 192 , 192 , 224 , 240 , 240 , 240 , 224 , 192 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0}
};

void setup() {
 pinMode(LATCH_PIN,OUTPUT);       // LATCH_PIN (Pin 12 am 74HC595)
 pinMode(DATA_PIN,OUTPUT);        // DATA_PIN  (Pin 14 am 74HC595)
 pinMode(CLOCK_PIN,OUTPUT);       // CLOCK_PIN (Pin 11 am 74HC595)
 pinMode(Hall_PIN,INPUT_PULLUP);  // interner PULUP für den Hallsensor-Pin

 setup_hardware_spi();            // SPI Konfigurieren
 configure_interrupts();          // Interrupts konfigurieren
}

void loop() {
  if (update==true)
  {
    update=false;
    if (aktuelles_segment++ >= (sectoren-1)) aktuelles_segment = 0; // Globusbild drehen
    next_element(aktuelles_segment);
  }
}

void next_element(int Element){
    digitalWrite(LATCH_PIN, LOW); //zum Start der Übermittlung wird der latchPin auf LOW gezogen
    for (int i=0 ; i < anzahl_register ; i++)
      spi_shiftOut(byte_register[i][Element]); //jetzt werden die Daten in die 74HC595 geschrieben
    digitalWrite(LATCH_PIN, HIGH); // am Ende der Übermittlung latchPin wieder auf HIGH ziehen
}

//----------------------------------------------------------------
//                           Interrupts
//----------------------------------------------------------------

// Hilfsmakro zum Setzen von Bits
#define bitset(var,bitno) ((var) |= (1 << (bitno)))

// Timer und Interrupts konfigurieren
void configure_interrupts(void)
{
  cli();    // Interrupts ausschalten

  //  timer0 - (8 bit Timer)
  // verantwortlich für das Timing der LED's
  TCCR0A = 0;
  TCCR0B = 0;
  bitset(TCCR0A, WGM01);   // CTC mode
  bitset(TCCR0B, CS01);    // prescaler clk / 64
  bitset(TCCR0B, CS00);    // prescaler clk / 64
  bitset(TIMSK0, OCIE0A);  // compare interrupt

  //  timer1 - (16 bit Timer)
  //  aus diesem Timer wird die Anzahl der Prozessortackte pro Umdrehung ermittelt
  TCCR1B = 0;
  TCCR1A = 0;
  bitset(TCCR1B, CS11);   // prescaler clk / 64
  bitset(TCCR1B, CS10);   // prescaler clk / 64
  bitset(TIMSK1, TOIE1);  // overflow interrupt

  // Konfiguration vom Hall-Sensor-PIN (Arduino Pin 2)
  EICRA = _BV(ISC01);    // Interupt wird bei fallender Flanke ausgelöst
  EIMSK |= _BV(INT0);    // Hardware interrupt einschalten
  sei();  // Interrupts einschalten
}

// Dieses Interrupt wird bei jeder Umdrehung vom Hallsensor ausgelöst
// Hier werden die beiden Timer auf 0 gesetzt

ISR(INT0_vect)
{
  // Wie viele Pozessortakte sind seit dem letztem Umlauf vergangen?
  dauer_segment=(TCNT1 / sectoren);
  // Änderungen der Sektorenlänge werden erst ab einer bestimmten Schwelle angewandt,
  // dadurch ergibt sich ein ruhigeres Bild
  if ( ((OCR0A-dauer_segment)>1) || ((dauer_segment-OCR0A)>2) ) OCR0A = dauer_segment;

  TCNT1 = 0; // 16 bit Timer auf 0 setzen (timer1)
  TCNT0 = 0; // 8 bit Timer auf 0 setzen (timer0)

  // nach 3 Umdrehungen um einen Sektor drehen
  if (umdrehung++ >=3) {
      umdrehung=0;
      if (dreh_position-- <=0) dreh_position = sectoren-1; // Drehung im Uhrzeigersinn
  }
  aktuelles_segment=dreh_position;
  update=true;
}

// Dieser Interrupt wird vom 8-bit-Timer ausgelöst, der .
// wiederum vom Hallsensor-Impuls gestartet

ISR(TIMER0_COMPA_vect) {
  // SPI-Shift out der Daten anstoßen
   update=true;
}
