void setup_hardware_spi(void)
{
	byte clr;
	SPCR |= (_BV(SPE) | _BV(MSTR));   // enable SPI als Master 
	clr = SPSR;                       // SPSR Register löschen
	clr = SPDR;                       // SPDR Register löschen
	SPCR &= ~(_BV(SPR1) | _BV(SPR0)); //  prescaler auf halbe Prozessorfrequenz
	SPSR |= _BV(SPI2X);               // Leztes Byte zuerst senden
}

byte spi_shiftOut(byte data)
{
	SPDR = data;		        // Startet die Übertagung
	while (!(SPSR & _BV(SPIF))) {}; // Auf das Ende der Übertragubng warten
	return SPDR;	
}

