/////////////////////////////////////////////////////////////////
// POV Globe
// Ulli Schmerold
// 4/2016
// Realisiert mit Serial Peripheral Interface (SPI)
/////////////////////////////////////////////////////////////////

 // SPI Pins am Arduino Nano: 10 (SS), 11 (MOSI), 12 (MISO), 13 (SCK).
 // DATA_IN 12  ==> brauchen wir nicht
 #define DATA_PIN  11
 #define CLOCK_PIN 13
 #define LATCH_PIN 10
 #define Hall_PIN 2

 long dauer_umlauf;        // Die Zeitdauer einer Umdrehung in Pozessortakten
 byte dauer_segment;       // Speicher die Dauer von einem Segment in Pozessortakten
 int aktuelles_segment=0;  // Welches Segment wird gerade gezeigt
 int umdrehung = 0;        // Zählen der Umdrehungen
 int dreh_position=0;      // Damit der Glob sich auch drehen kann
 boolean update=false;     // Löst die Datenübertragung in die Schieberegister aus
 boolean start=true;

 // Die Daten für den Globe werden im POV Globe Calculator ermittelt
 // und in einem 2 dimmensionalen Array gespeichert
 // Jede Zahl(Byte) steuert 8 LEDs an
 // Ein Sektoren des Globes entsteht jeweils aus den Werten, die untereinader stehen
byte anzahl_register = 4; // Anzahl der Register
byte sectoren = 140;       // Anzahl der Sektoren pro Umlauf
byte byte_register [4][140] = {
 {0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0},
 {0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0},
 {0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0},
 {0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0}
};






void setup() {
 pinMode(LATCH_PIN,OUTPUT);       // LATCH_PIN (Pin 12 am 74HC595) 
 pinMode(DATA_PIN,OUTPUT);        // DATA_PIN  (Pin 14 am 74HC595)
 pinMode(CLOCK_PIN,OUTPUT);       // CLOCK_PIN (Pin 11 am 74HC595)
 pinMode(Hall_PIN,INPUT_PULLUP);  // interner PULUP für den Hallsensor-Pin
 
 setup_hardware_spi();            // SPI Konfigurieren
 configure_interrupts();          // Interrupts konfigurieren
}

void loop() {
  if (start==true){
    write_string("Hallo Maker",1,0);
    write_string("Das ist ein Text",2,0);
    start=false;
  }

  if (update==true)
  {
    update=false;
    if (aktuelles_segment++ >= (sectoren-1)) aktuelles_segment = 0; // Globusbild drehen
    next_element(aktuelles_segment);
  } 
}



void next_element(int Element){  
    digitalWrite(LATCH_PIN, LOW); //zum Start der Übermittlung wird der latchPin auf LOW gezogen
    for (int i=0 ; i < anzahl_register ; i++)
      spi_shiftOut(byte_register[i][Element]); //jetzt werden die Daten in die 74HC595 geschrieben
    digitalWrite(LATCH_PIN, HIGH); // am Ende der Übermittlung latchPin wieder auf HIGH ziehen
}


//----------------------------------------------------------------
//                           Interrupts
//----------------------------------------------------------------

// Hilfsmakro zum Setzen von Bits
#define bitset(var,bitno) ((var) |= (1 << (bitno)))

// Timer und Interrupts konfigurieren
void configure_interrupts(void)
{
  cli();    // Interrupts ausschalten

  //  timer0 - (8 bit Timer)
  // verantwortlich für das Timing der LED's
  TCCR0A = 0;
  TCCR0B = 0;  
  bitset(TCCR0A, WGM01);   // CTC mode
  bitset(TCCR0B, CS01);    // prescaler clk / 64
  bitset(TCCR0B, CS00);    // prescaler clk / 64
  bitset(TIMSK0, OCIE0A);  // compare interrupt

  //  timer1 - (16 bit Timer)
  //  aus diesem Timer wird die Anzahl der Prozessortackte pro Umdrehung ermittelt
  TCCR1B = 0;
  TCCR1A = 0;
  bitset(TCCR1B, CS11);   // prescaler clk / 64
  bitset(TCCR1B, CS10);   // prescaler clk / 64 
  bitset(TIMSK1, TOIE1);  // overflow interrupt

  // Konfiguration vom Hall-Sensor-PIN (Arduino Pin 2)
  EICRA = _BV(ISC01);    // Interupt wird bei fallender Flanke ausgelöst
  EIMSK |= _BV(INT0);    // Hardware interrupt einschalten

  sei();  // Interrupts einschalten
}


// Dieses Interupt wird bei jeder Umdrehung ausgelöst
// Hier werden die beiden Timer auf 0 gesetzt
ISR(INT0_vect)
{
  // Wie viele Pozessortakte sind seit dem letztem Umlauf vergangen?
  // dauer_umlauf = TCNT1;
  dauer_segment=(TCNT1 / sectoren);
  // Änerungen an der Sektorenlänge werden ert ab einer bestimmten Schwelle angewandt
  // Dadurch wird der Globus ruhiger
  if ( ((OCR0A-dauer_segment)>1) || ((dauer_segment-OCR0A)>2) ) OCR0A=dauer_segment;
  

  // 16 bit Timer auf 0 setzen (timer1)
  TCNT1 = 0;
  // 8 bit Timer auf 0 setzen (timer0) 
  TCNT0 = 0;
  


  // nach 3 umdrehungen einen Sektor drehen
  
  if (umdrehung++ >=3){
      umdrehung=0;
      if (dreh_position++ >= sectoren) dreh_position = 0; //rehung gegen den Uhrzeigersinn   
    }  
    
  // nach 3 umdrehungen einen Sektor drehen
  /*
  if (umdrehung++ >=3)
  {
      umdrehung=0;
      if (dreh_position-- <=0) dreh_position = sectoren-1; // Drehung im Uhrzeigersinn    
    } 
   */ 
  aktuelles_segment=dreh_position;
  update=true; 

}


// Dises Interrupt wird vom 8bit Timer ausgelößt.
// Das Timerintervall wird nach jedem Auslösen der Lichtschranke berechnet
// und an das OCROA - register übergeben
ISR(TIMER0_COMPA_vect) {
  // SPI-Shift out der Daten anstoßen 
   update=true;
}







