#include "LPC8xx.h"
#include "lpc8xx_spi.h"

#define SPI_STAT_RXRDY (0x1)
#define SPI_STAT_TXRDY (0x2)
#define SPI_TXDATCTL_SSEL_N(s) ((s) << 16)
#define SPI_TXDATCTL_EOT (1 << 20)
#define SPI_TXDATCTL_FLEN(l) ((l) << 24)
#define ADC_CH_D0 0b001000000

void SCT_IRQHandler() {
  uint16_t rcv_data[2];
  uint16_t signal = 0;
  static uint8_t channel = 0;
  static uint16_t bitcrush = 0;

  channel ^= ADC_CH_D0; // Kanal abwechseln
  // 0b11000 senden, um die Konversion auf Kanal 1 zu starten
  while(~LPC_SPI0->STAT & SPI_STAT_TXRDY); // warten bis der SPI zum senden bereit ist und senden
  LPC_SPI0->TXDATCTL = SPI_TXDATCTL_FLEN(15) | SPI_TXDATCTL_SSEL_N(0xe) | 0b0000011000000000 | channel;
  while(~LPC_SPI0->STAT & SPI_STAT_RXRDY); // warten bis der SPI die Daten fertig empfangen hat
  rcv_data[0] = LPC_SPI0->RXDAT; // empfangene Daten in rcv_data[0] speichern
  while(~LPC_SPI0->STAT & SPI_STAT_TXRDY); // warten bis der SPI zum senden bereit ist und senden
  LPC_SPI0->TXDATCTL = SPI_TXDATCTL_FLEN(7) | SPI_TXDATCTL_EOT | SPI_TXDATCTL_SSEL_N(0xe) | 0;
  while(~LPC_SPI0->STAT & SPI_STAT_RXRDY); // warten bis der SPI die Daten fertig empfangen hat
  rcv_data[1] = LPC_SPI0->RXDAT; // empfangene Daten in rcv_data[1] speichern
  rcv_data[0] &= 0x0f; // ungueltige Bits 0 setzen

  if(channel != ADC_CH_D0) {
    signal = (rcv_data[0] << 8) | rcv_data[1];
    signal = (signal >> 2) >> bitcrush;
    LPC_SCT->MATCHREL_L[1] = signal << bitcrush;
  } else {
    bitcrush = rcv_data[0]; // 4 bits => 0 bis 15, gebraucht wird aber 0 bis 9
    bitcrush = (bitcrush * 5) >> 3; // (15 * 5) >> 3 = 75 >> 3 = 9
  }
}

void configurePins() {
  LPC_SYSCON->SYSAHBCLKCTRL |= (1 << 7); // SWM Clock anschalten
  LPC_SWM->PINASSIGN3 = 0x05ffffffUL; // SPI0_SCK
  LPC_SWM->PINASSIGN4 = 0xff020403UL; // SPI0_MOSI, SPI0_MISO, SPI0_SSEL
  LPC_SWM->PINASSIGN6 = 0x00ffffffUL; // CTOUT_0
  LPC_SWM->PINENABLE0 = 0xffffffffUL;
}

int main(void) {
  //SystemCoreClockUpdate(); // => statt 12 MHz will ich 30 MHz:
  LPC_SYSCON->PDRUNCFG &= ~(1 << 7); // PLL anschalten
  LPC_SYSCON->SYSPLLCLKSEL = 0; // interner RC als Mainclock
  LPC_SYSCON->SYSPLLCLKUEN = 0;
  LPC_SYSCON->SYSPLLCLKUEN = 1; // Clock Update
  LPC_SYSCON->SYSPLLCTRL = 4 | (1 << 5); // M = 4+1, P = 2 => PLLout = 12*5/2 = 30 MHz
  while(~LPC_SYSCON->SYSPLLSTAT & 1); // warten auf PLL Lock
  LPC_SYSCON->MAINCLKSEL = 0x3; // PLL als Clock verwenden
  LPC_SYSCON->MAINCLKUEN = 0;
  LPC_SYSCON->MAINCLKUEN = 1; // Clock Update
  while (!(LPC_SYSCON->MAINCLKUEN & 0x01)); // warten bis Clock Update fertig

  configurePins();

  LPC_SYSCON->SYSAHBCLKCTRL |= (1 << 8); // SCT Clock anschalten
  LPC_SYSCON->PRESETCTRL |= (1 << 8); // SCT aus dem Reset holen
  LPC_SCT->CONFIG |= (1 << 17); // AUTOLIMIT_L (Match 0 loest Counter Clear aus)
  LPC_SCT->CONFIG &= ~((1 << 1) | (1 << 2)); // Bus Clock verwenden
  LPC_SCT->MATCHREL_L[0] = 1024; // SCT Limit = 1024
  LPC_SCT->MATCHREL_L[1] = 511; // Pulsweite 50/50 setzen
  LPC_SCT->EVENT[0].STATE = 0xFFFFFFFF; // Event 0 tritt in allen States auf
  LPC_SCT->EVENT[0].CTRL = (1 << 12);  // Event 0 ist mit Match 0 verknuepft
  LPC_SCT->EVENT[1].STATE = 0xFFFFFFFF; // Event 1 tritt in allen States auf
  LPC_SCT->EVENT[1].CTRL = (1 << 0) | (1 << 12); // Event 1 ist mit Match 1 verknuepft
  LPC_SCT->OUT[0].SET = (1 << 0); // Event 0 setzt SCTx_OUT0 high
  LPC_SCT->OUT[0].CLR = (1 << 1); // Event 1 setzt SCTx_OUT0 low
  LPC_SCT->EVEN = (1 << 0); // Event 0 loest Interrupt aus
  LPC_SCT->CTRL_L &= ~(1 << 2); // Timer starten

  SPI_Init(LPC_SPI0,0x40,CFG_MASTER,DLY_PREDELAY(0)|DLY_POSTDELAY(0)|DLY_FRAMEDELAY(0)|DLY_INTERDELAY(0));

  NVIC_EnableIRQ(SCT_IRQn);
  while(1) {
  }
}
