// Arduino Brain Library
// Serial out example, 	grabs the brain data and sends CSV out over the hardware serial.
// Eric Mika, 2010

#include <Adafruit_NeoPixel.h>
#include <Brain.h>
#include <Servo.h> 

#define PIN 12 
Servo myservo; 
int lastValue = 0;
int count = 0;


// Set up the brain parser, pass it the hardware serial object you want to listen on.
Brain brain(Serial);
Adafruit_NeoPixel strip = Adafruit_NeoPixel(10, PIN, NEO_GRB + NEO_KHZ800);

void load(){
  myservo.write(45);
  delay(260);
  myservo.write(110);
}
 
void fire(){
  myservo.write(140); 
  delay(260);
  load();
}


void setup() {
	// Start the hardware serial.
	Serial.begin(9600);
        myservo.attach(14);  // attaches the servo on pin 9 to the servo object 
        myservo.write(110);
        strip.begin();
        strip.show();
}

void loop() {
	// Expect packets about once per second.
	// The .readCSV() function returns a string (well, char*) listing the most recent brain data, in the following format:
	// "signal strength, attention, meditation, delta, theta, low alpha, high alpha, low beta, high beta, low gamma, high gamma"	
	if (brain.update()) {
  	       Serial.println(brain.readErrors());
	       Serial.println(brain.readCSV());
               Serial.println(brain.readAttention());
               
               strip.setBrightness(50);

               if(brain.readAttention() > 5){
                  strip.setPixelColor(0, 255, 0, 0);
                  strip.show();
               } else if  (brain.readAttention() < 25 ) {
                  strip.setPixelColor(0, 0, 0, 0);
                  strip.show();
               }
                            
               if(brain.readAttention() > 25){
                  strip.setPixelColor(1, 255, 165, 0);
                  strip.show();
               } else if  (brain.readAttention() < 40 ) {
                  strip.setPixelColor(1, 0, 0, 0);
                  strip.show();
               }
               
               if(brain.readAttention() > 40){
                  strip.setPixelColor(2, 255, 215, 0);
                  strip.show();
                 
               } else if  (brain.readAttention() < 60 ) {
                  strip.setPixelColor(2, 0, 0, 0);
                  strip.show();
               }
               
               if(brain.readAttention() > 60){
                  strip.setPixelColor(3, 0, 128, 0);
                  strip.show();
                  
               } else if  (brain.readAttention() < 60 ) {
                  strip.setPixelColor(3, 0, 0, 0);
                  strip.show();
               }
               
               if ( brain.readAttention() > 60 && lastValue < brain.readAttention()){
                  if (count == 0) fire();
                  count ++;
               }
               
               if (count > 1 || brain.readAttention() < lastValue) count = 0;
               lastValue = brain.readAttention();
	}
}
