/*
 * Sehr einfache WLAN-Anbindung mit ESP8266
 * Florian SchÃ¤ffer, Redaktion Make: http://www.make-magazin.de/
 * VII/2016
 * 
 * Zeigt Tweets an.
 * Benoetigt einen Parser als Webservice, der die Daten bei twitter abholt, da dort SSL, was
 * der ESP8266 nicht kann. Der Parser liefert den ersten Tweet auf mind. 70 Zeichen aufgefuellt mit Blanks, wenn 
 * kuerzer. Zudem konvertiert er UTF-8 von twitter in ISO 8591-1
 * Wenn nach Anzeige von "W" bis "+" und dann weiter Z Taste gedrueckt wird, kann man den Suchstring aendern
 * Mit Z- Taste Buchstabe rauf, Cursor links/rechts mit Joystick. Joystisck auf = Fertig
 */

#include <SoftwareSerial.h>

const String MYSSID = "xxx";           // case sensitive!
const String MYPASSWD = "xxx";
const uint32_t PAUSENZEIT = 20000;           // alle 20 Sekunden aktualisieren
const String DST_IP = "xxx.de";           
const String URL = "/xxx.php?q=";           
String HASHTAG = "makeflipdot";           

boolean connectWiFi(void);
int8_t espInit(void);
void holedata (void);

SoftwareSerial esp8266Serial(10, 11); // RX, TX

void texteingabe (void)
{
  uint8_t x = 0, i;
  uint8_t ascii = 45;
  char tweethashtag[22];

  nunchuck_get_data();  // verwerfen
  writechar (ascii, x * 6, 0);
  for (i = 1; i <= 5; i++)                // Cursor neue Pos. setzen
    flipdot_pixel (x * 6 + i, 9, 1);  
  for (i = 0; i <= 22; i++)                // Leeren
    tweethashtag[i] = '\0';

  do
  {
    tweethashtag[x] = ascii;
    
    nunchuck_get_data();

//  Serial.println (nunchuck_cbutton(), DEC);
//  Serial.println (nunchuck_zbutton(), DEC);

    if (nunchuck_cbutton())         // aufwaerts
    {
      ascii++;
      if (ascii > 90)    // z => a
        ascii = 45;
    }

    // Mittelpos Nunchuck Joystick etwa bei 180
    if ((nunchuck_joyx() < 70) && (x != 0))           // links
    {
      for (i = 1; i <= 5; i++)                // Cursor bisherige Pos. loeschen
        flipdot_pixel (x * 6 + i, 9, 0);  
      x--;
      ascii = tweethashtag[x];
      for (i = 1; i <= 5; i++)                // Cursor neue Pos. setzen
        flipdot_pixel (x * 6 + i, 9, 1);  
    }
    if ((nunchuck_joyx() > 200) && (x != 22))         // rechts
    {
      for (i = 1; i <= 5; i++)                // Cursor bisherige Pos. loeschen
        flipdot_pixel (x * 6 + i, 9, 0);  
      x++;
      if (!tweethashtag[x])
        ascii = 45;
      else
        ascii = tweethashtag[x];
      for (i = 1; i <= 5; i++)                // Cursor neue Pos. setzen
        flipdot_pixel (x * 6 + i, 9, 1);  
    }
    
    writechar (ascii, x * 6, 0);

    while (nunchuck_zbutton() || nunchuck_cbutton() || (nunchuck_joyx() < 70) || (nunchuck_joyx() > 200))    // bis losgelassen und Joystich in Mitte
      nunchuck_get_data();   
    
    delay (50);
    nunchuck_get_data();   
  } while (nunchuck_joyy() < 200) ;  // solange nicht Up

  HASHTAG = "";
  for (i = 0; i <= x; i++)                // Leeren
    HASHTAG += tweethashtag[i];
  
}

boolean connectWiFi(void)
{
  //Serial.println("AT+CWMODE=1");
  String cmd="AT+CWJAP=\"";
  cmd+=MYSSID;
  cmd+="\",\"";
  cmd+=MYPASSWD;
  cmd+="\"";
  esp8266Serial.println(cmd);
  //Serial.println(cmd);
  delay(2000);
  if(esp8266Serial.find((char*)"OK"))
  {
    //Serial.println("OK, Connected to WiFi.");
    return true;
  }
  else
  {
    //Serial.println("Can not connect to the WiFi.");
    return false;
  }
}

int8_t espInit(void)
{
  writechar ('W', 0, 0);
  esp8266Serial.begin(9600);
  esp8266Serial.setTimeout(5000);
  //Serial.println("WiFi - Module reset");
  esp8266Serial.println("AT+RST");
  delay(1000);


  if(esp8266Serial.find((char*)"OK")) 
  {
    Serial.println("RDY");
  }
  else
  {
    //Serial.println("Module not respond.");
  }
  
  // try to connect to wifi
  boolean connected=false;
  for(int i=0;i<5;i++)
  {
    if(connectWiFi())
    {
      connected = true;
      //Serial.println("Connected to WiFi...");
      writechar ('+', 0, 0);
      break;
     }
  }
  if (!connected)
  {
    //Serial.println("Coud not connect to WiFi.");
    writechar ('-', 0, 0);
    return -1;
  }
  delay(5000);

  esp8266Serial.println("AT+CIPMUX=0"); // set to single connection mode
  //Serial.println("set to single connection mode");

  delay(300);  
  return 0;
}

void holedata (void)
{
  uint32_t i = 0; //timeout counter
  char text[70] = {0};
  char c;
  uint8_t x, y;

  // Wenn nach 'W' Z gedrueckt wird (bis '+' und laenger)
  nunchuck_get_data();   // verwerfen 
  if (nunchuck_get_data() && nunchuck_zbutton())    // Nunchuck vorhanden/Antwort? AND Z-Button pressed?
    texteingabe();

  flipdot_cls(0);

  while(1)
  {
    String cmd = "AT+CIPSTART=\"TCP\",\"";
    cmd += DST_IP;
    cmd += "\",80";
    //Serial.println(cmd);
    esp8266Serial.println(cmd);
    
    if(esp8266Serial.find((char*)"Error")) return;
    
    cmd = "GET " + URL + HASHTAG;
    cmd += " HTTP/1.0\r\nHost:" + DST_IP +"\r\n\r\n";
  
    Serial.println(cmd);
    //Serial.println(cmd.length());
    
    esp8266Serial.print("AT+CIPSEND=");
    esp8266Serial.println(cmd.length());
  
    delay(500);
  
    if(esp8266Serial.find((char*)">"))
    {
      //Serial.print(">");
    }
    else
    {
      esp8266Serial.println("AT+CIPCLOSE");
      //Serial.println("connection timeout");
      delay(1000);
      return;
    }
    
    //Serial.print(cmd);
    esp8266Serial.print(cmd);
   
    /*
     * Beispielantwort:
     *
     * Date: Fri, 22 Jul 2016 08:03:57 GMT
     * Server: Apache
     * X-Powered-By: PleskLin
     * MS-Author-Via: DAV
     * Vary: Accept-Encoding
     * Connection: close
     * Content-Type: text/html
     * 
     * <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
     * 
     * <html>
     * <head>
     *   <title>Twitter</title>
     * </head>
     * 
     * <body>
     * <pre>RT Stcrow: The Candidate, Donald J. Trump, Republican National Convention.  #RNCinCLE #nytrnc #TrumpPence16 http://ift.tt/29RjRvv&amp;nbsp; &hellip;</pre>
     * 
     * </body>
     * </html>
     */

    for (i = 0; i <= 69; i++)
      text[i] = 32;     // mit Blanks fuellen
    
    while (!esp8266Serial.find((char*)"<pre>"));   // empfange/verwerfe bis ""
  
    // Das gleichzeitige Ausgeben auf dem Display dauert zu lange => erst alles einlesen, dann ausgeben
    i = 0;
    for (x = 0; x <= 69; x++)       //  einlesen 
    {
      while ((!esp8266Serial.available()) && (i < 60000))   // warte auf Zeichen
        i++;
      text[x]  = esp8266Serial.read();
//      Serial.print(text[x]);
    }

  
    // ######################### Ausgabe

    i = 0;
    x = 0;
    y = 0;
    while ((i < 69) && (text[i] != '<'))
    {
      if (x == 23)   // Zeilenende erreicht
      {
        x = 0;
        y++;
      }
      writechar (text[i], x * 6, y * 8);
      Serial.print(text[i]);
      i++;
      x++;
    }

//    esp8266Serial.println("AT+CIPCLOSE");
    delay (PAUSENZEIT);    // Server entlasten
    Serial.println();
  }

}



