
/*
 * Steuersoftware fuer ein Flipdot-Display mit 5 Panels à 28 Spalten und 24 Zeilen = 140 x 24 Dots
 * 
 * VII/2016
 * Florian Schäffer, Redaktion Make: http://www.make-magazin.de/
 * 
 * Einfache Kommunikation ohne wirksame Fehlerkorrektur per RS232, 9600, 8N1
 * Sendet ein paar Rueckmeldungen. Mit den Kommandos (HEX) ...
 * 05 = Text empfangen
 * 06 = CLS schwarz
 * 07 = CLS gelb
 * 08 = Bild empfangen
 * ... werden Aktionen eingeleitet. Ansclhiessend sind ggf. Daten zu senden.
 * ISO8591-1 Zeichensatz mit 256 Zeichen im Flash
 * 
 */

#include <Wire.h>                             // I2C
#include <util/delay.h>
#include <avr/interrupt.h>


#include "flipdot.h"
#include "nunchuck_funcs.h"
#include "snake.h"
//#include "esp8266_twitter.h"
#include "esp8266_openweather.h"

uint8_t rev_bits(uint8_t);
void empfange_bmp (void);
void empfange_text (void);

String inputString = "";         // a string to hold incoming data
  
/*
 * @brief   Arduinos Setup Routine. 1x bei Start automatisch
 * @param   none
 * @return  none
 */
void setup() 
{
  Wire.begin(); // join i2c bus (address optional for master)
  Serial.begin(9600);
  nunchuck_init();
  Serial.println("START");    
  inputString.reserve(TXTZEICHEN_ZEILE + 1);
}


/*
 * @brief   Wartet auf Text an ser. Schnittstelle und gibt ihn aus. Sture Funktion, die auf 140 Zeichen wartet
 * @param   none
 * @return  none
 */
void empfange_text(void)
{
  uint8_t b,i, x, y;
  char zeichen = 0;

  _delay_ms(100);
  while (Serial.available())  // alles im In-Buffer verwerfen
    Serial.read();            

  Serial.println("TEXT");
  while (Serial.available() == 0) {};       // Wait for user input
  inputString = Serial.readString();        // Read user input 
          
  Serial.print(inputString);    // \n im Eingabestring, also auch bei Ausgabe => Zeilenumbruch 
  flipdot_cls(0);

// for (b = 0; b <= 1; b++)    // 2 x schreiben aber erst einmal ausgeben
  {
    i=0;
    x=0;
    y=0;
    while ((inputString[i] != '\n') && (inputString[i] != 0) && (i < (TXTZEICHEN_ZEILE * 3)))
    {
        if (x >= TXTZEICHEN_ZEILE)      // Zeichen pro Zeile wurden ausgegeben => nächste Zeile
        {
          x = 0;
          y += 8;
        }

        writechar (inputString[i], x*6, y);
        i++;
        x++;
    }
  }
  Serial.println("READY TXT");
}

/*
 * @brief   Empfaengt ein Bitmap und zeigt es an. Sture Funktion, die auf 420 Bytes wartet
 *          Spaltenweises empfangen von links oben nach rechts unten. Pro Byte = 8 Pixel
 *          LSB im Byte = erstes/oberes Pixel => 3 Bytes pro Spalte
 * @param   none
 * @return  none
 */
void empfange_bmp(void)
{
  uint8_t data, x, y, i;
  
  _delay_ms(100);
  while (Serial.available())  // alles im In-Buffer verwerfen
    Serial.read();            

  flipdot_cls(0);
  Serial.println("BMP");

  for (x = 0; x < 140; x++)
  {
    for (y = 0; y < 3; y++)
    {
      while (Serial.available() == 0) {};   // warte auf nächstes Zeichen
      data = Serial.read();

      for (i = 0; i < 8; i++)
      {
        if ((data >> i) & 0x01)           // LSB = oberer/erster Pixel
          flipdot_pixel (x, y * 8 + i, 1);
        else
          flipdot_pixel (x, y * 8 + i, 0);
      }
       Serial.println(data);    // "Handshake"
    }
  }
  Serial.println("READY PIC");
}


  
/*
 * @brief   Arduinos Standard main-Ersatz. Wird endlos ausgefuehrt
 * @param   none
 * @return  none
 */
void loop(void) 
{
  uint16_t befehl;

  Serial.println("GO");
  
  befehl = DISPLAYDELAY;
  DISPLAYDELAY = 800;
  flipdot_cls(1);
  flipdot_cls(0);
  DISPLAYDELAY = befehl;

  // pruefe, ob Z-Button bei Start gedrueckt ist. Dann Game, sonst FlipDot
  nunchuck_init(); // send the initilization handshake
  delay(100);
  nunchuck_get_data();   // verwerfen 
  delay(100);
  nunchuck_get_data();   // verwerfen 
  delay(100);
  //Serial.println(nunchuck_joyx(),DEC);

  if (nunchuck_get_data() && (nunchuck_joyx() < 70))      // Nunchuck vorhanden/Antwort?  und links
    initsnake ();

  if (nunchuck_get_data() && (nunchuck_joyx() > 200))    // Nunchuck vorhanden/Antwort? und rechts?
  {
    while(1)
    {
      espInit();
      holedata();
    }
  }
 
  Serial.println("READY");

  while (1)
  {
    while (Serial.available() == 0)    {    };      // warte auf Zeichen
    
    befehl = Serial.read();
    
    switch (befehl)
    {
      case 0x06 : flipdot_cls (0);          // CLS schwarz
                  Serial.println ("READY");
                  break;
      case 0x07 : flipdot_cls (1);          // CLS gelb
                  Serial.println ("READY");
                  break;
      case 0x08 : empfange_bmp ();     // Bild empfangen
                  break;
      case 0x05 : empfange_text ();         // Text empfangen
                  break;
    }
  }
}


