const unsigned long BAUD_RATE = 9600;
const unsigned char MAX_ANALOG_PINS = 6;
const unsigned char MAX_DIGITAL_PINS = 14;

void setup() {
  Serial.begin(BAUD_RATE);
}

void loop() {
  // Werte aller analogen Eingänge ausgeben.
  for (unsigned char analog_pin = 0; analog_pin < MAX_ANALOG_PINS; analog_pin++) {
    Serial.print("A");
    Serial.print(analog_pin);
    Serial.print("=");
    Serial.print(analogRead(analog_pin));
    Serial.print(",");    
  }
  
  // Werte aller digitalen Eingänge ausgeben.
  for (unsigned char digital_pin = 0; digital_pin < MAX_DIGITAL_PINS; digital_pin++) {
    Serial.print("D");
    Serial.print(digital_pin);
    Serial.print("=");
    Serial.print(digitalRead(digital_pin));
    if (digital_pin < MAX_DIGITAL_PINS -1) {
      Serial.print(",");
    }
  }
  Serial.println();
}

