#include <Servo.h> 

const unsigned long BAUD_RATE = 9600;
const unsigned char MOTOR_PIN = 9;
const unsigned int MOTOR_PAUSE = 15;
const unsigned int MIN_WINKEL = 2;
const unsigned int MAX_WINKEL = 180;

Servo servo;
bool neuer_winkel = false;
unsigned int aktueller_winkel = 0;

void setup() { 
  Serial.begin(BAUD_RATE);
  servo.attach(MOTOR_PIN);
  delay(MOTOR_PAUSE);
  servo.write(1);
  delay(MOTOR_PAUSE);
} 

void serialEvent() {
  aktueller_winkel = Serial.parseInt();
  if (Serial.read() == '\n') {
    neuer_winkel = true;
  }
}

void loop() {
  if (neuer_winkel) {
    neuer_winkel = false;
    if (aktueller_winkel < MIN_WINKEL) {
      aktueller_winkel = MIN_WINKEL;
    } else if (aktueller_winkel > MAX_WINKEL) {
      aktueller_winkel = MAX_WINKEL;
    }
    Serial.print(aktueller_winkel);
    Serial.println(" Grad.");
    servo.write(aktueller_winkel);
    delay(MOTOR_PAUSE);
  }
}

