import processing.serial.*;
import cc.arduino.*;

final byte SERVO_PIN = 9;
final byte TEMP_PIN = 0;
final float MIN_TEMP = 0;
final float MAX_TEMP = 40;
final int ZEICHEN_GROESSE = 32;
final int BREITE = 640;
final int HOEHE = 480;
final int CX = BREITE / 2;
final int CY = HOEHE / 2;
final int RADIUS = 200;

Arduino arduino;

void settings() {
  size(BREITE, HOEHE);
}

void setup() {
  PFont zeichensatz = createFont("Arial", ZEICHEN_GROESSE, true);
  textFont(zeichensatz, ZEICHEN_GROESSE);
  String arduinoPort = "/dev/cu.usbmodem24311"; // Hier anpassen!
  arduino = new Arduino(this, arduinoPort);
  arduino.pinMode(SERVO_PIN, Arduino.SERVO);
}

void draw() {
  background(255);
  fill(0);
  zeichneThermometer();
  float temperatur = ermittleTemperatur();
  zeichneTemperatur(temperatur);
  steuereMotor(temperatur);
  delay(1000); 
}

void steuereMotor(float temperatur) {
  float position = map(min(temperatur, MAX_TEMP), MIN_TEMP, MAX_TEMP, 0, 180);
  arduino.servoWrite(SERVO_PIN, (int)position);
}

float ermittleTemperatur() {
  float spannung = arduino.analogRead(TEMP_PIN) * 5000 / 1024.0;
  float temperatur = (spannung - 500) / 10; // TMP36
  // float temperatur = spannung / 10; // LM35 CZ
  return temperatur;
}

void zeichneTemperatur(float temperatur) {
  float t = map(min(temperatur, MAX_TEMP), MIN_TEMP, MAX_TEMP, -PI, 0);
  stroke(255, 0, 0);
  line(CX, CY, CX + cos(t) * RADIUS * 0.95, CY + sin(t) * RADIUS * 0.95);
  textAlign(CENTER, CENTER);
  text(nf(temperatur, 0, 1) + "\u2103", BREITE / 2, HOEHE / 2 + 50);
}

void zeichneThermometer() {
  noFill();
  stroke(0);
  strokeWeight(2);
  arc(CX, CY, RADIUS * 2, RADIUS * 2, -PI, 0);
  beginShape(POINTS);
  int i = 0;
  for (float a = -180; a <= 0; a += 22.5, i += 5) {
    float winkel = radians(a);
    float x = CX + cos(winkel) * RADIUS * 0.95;
    float y = CY + sin(winkel) * RADIUS * 0.95;
    strokeWeight(3);
    vertex(x, y);
    text(i, CX + cos(winkel) * RADIUS * 0.80, CY + sin(winkel) * RADIUS * 0.80);
  }
  endShape();
  text("\u2103", CX, CY - RADIUS / 2);
}