/*
  Sketch to read the CO2-value from a MG811 CO2 Sensor module
  sending the value via http POST to a Node-RED Server
  by Markus Ulsass, Hamburg, Germany
*/

#include <ESP8266WiFi.h>
const char* ssid     = "HierDieSSIDEintragen"; // Eintragen der SSID
const char* password = "HierDasDazugehörigePasswortEintragen"; // Passwort
const char* host = "XXX.XXX.XXX.XXX"; // Hier wird die IP vom Raspberry Pi eingetragen

int sample = 0;

void setup()
{
  // WiFi Start
  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
  }

}

void loop()
{

  // Der MG 811 Sensor gibt eine analoge Spannung entsprechend der CO2-Konzentration
  // in der Luft aus. Unsere Kalibrierung ergab 965mV für 400ppm und 825mV für 2500ppm (20°C)
  // diese muss je nach Sensor, Operationsverstärker und Modul angepasst werden
  // Der ESP-ADC hat einen Bereich von 0-1023 in 10 bit, d.h. 1 bit = 0,0009775V/ 0,9775mV
  // entsprechend werden die Kalibrier-Werte unten im mapping umgerechnet und gesetzt

  for (byte i = 0; i < 5; i++) {
    sample = sample + analogRead(A0);
  }
  int sample_ergebnis = sample / 5;

  int valCO2 = map(sample_ergebnis, 987, 844, 400, 2500);

  sample = 0;
  sample_ergebnis = 0;

  // Aufbau der TCP-Verbindung mit unserem Raspberry Pi
  WiFiClient client;
  const int httpPort = 1880;
  if (!client.connect(host, httpPort)) {

    return;
  }

  int num = 0; // Variable für die Länge des Content-Length wird zurückgesetzt
  String var = "{\"airQuality\": {\"co2Value\": " + String(valCO2) + "}}"; // JSON-String für den http-POST
  num = var.length(); // Variable für Content.length

  // Senden des http POST zum RaspberryPi
  client.println("POST /co2 HTTP/1.1");
  client.println("User-Agent: ESP8266_Make");
  client.println("Host: " + String(host));
  client.println("Content-Type: application/json");
  client.println("Content-Length: " + String(num));
  client.println();
  client.print(var);
  client.println();
  delay(10);

  delay(2000); // Wartezeit bis zum nächsten Senden

}
