-- Measure the temperature and humidity (DHT22), brightness BH1750) and pressure (BMP180) and send the data to thingspeak.com

DHT_Pin = 4
LED_Pin = 0
SDA_PIN = 2 
SCL_PIN = 1 
BMP180_OSS = 0	--Oversampling for pressure Sensor 0 ... 3

--- Get values and send data to thingspeak.com
function postToThingSpeak()
    -- turn LED on
	gpio.write(LED_Pin, 0)		
	
	-- connection handle
    conn = net.createConnection(net.TCP, 0) 
	
	-- register all callback functions for TCP communication
	-- callback function for TCP Receive
    conn:on("receive", function(conn, payloadout)
        if (string.find(payloadout, "Status: 200 OK") ~= nil) then
            print("Posted OK");	--if posting was successful
        end
--        print(payloadout)
        --turn off LED
		gpio.write(LED_Pin, 1)
    end)
    
	-- callback function for TCP Connection
    conn:on("connection", function(conn, payloadout)
 
		print ("Posting...");
 
		-- read DHT22 Sensor
        status,temp,humi,temp_decimial,humi_decimial = dht.read(DHT_Pin)
		
		-- read BH1750 Sensor
        bh1750 = require("bh1750")
        bh1750.init(SDA_PIN, SCL_PIN)
        bh1750.read()
        lux = bh1750.getlux()
        bh1750 = nil
        package.loaded["bh1750"]=nil
    
		--read BMP180 Sensor
        bmp180 = require("bmp180")
        bmp180.init(SDA_PIN, SCL_PIN)
        bmp180.read(BMP180_OSS)
        t = bmp180.getTemperature()
        p = bmp180.getPressure()

		--print the values for debugging and testing
        print("DHT Temperature:"..temp..";".."Humidity:"..humi)
        print("Brightness: "..lux.." lx")
        print("Temperature: "..(t/10).." deg C")
        print("Pressure: "..(p / 100).." mbar")

		---- callback function for TCP Send
        conn:send("GET /update?api_key=HB5IZJ25E82JEMI7&field1="..temp.."&field2="..humi.."&field3="..lux.."&field4="..(p / 100).."&field5="..(t/10)
        .. " HTTP/1.1\r\n"
        .. "Host: api.thingspeak.com\r\n"
        .. "Connection: close\r\n"
        .. "Accept: */*\r\n"
        .. "User-Agent: Mozilla/4.0 (compatible; esp8266 Lua; Windows NT 5.1)\r\n"
        .. "\r\n")

        collectgarbage();
    end)

	-- callback function for TCP Disconnection
    conn:on("disconnection", function(conn, payloadout)
        conn:close();
        collectgarbage();
    end)

--open connection to thingspeak API    
conn:connect(80,'api.thingspeak.com')
  
end
--run the posting funcion once
postToThingSpeak()
-- start Timer to send data every 60 sec
tmr.alarm(2, 60000, 1, function() postToThingSpeak() end )
