-- Measure the temperature and humidity (DHT22), brightness BH1750) and pressure (BMP180) and send the data to thingspeak.com

DHT_Pin = 4
LED_Pin = 0
SDA_PIN = 2 
SCL_PIN = 1 
BMP180_OSS = 3	--Oversampling for pressure Sensor 0 ... 3

--- Get values and send data to thingspeak.com
function Test()
  
    -- turn LED on
	gpio.write(LED_Pin, 0)		

    print ("waiting...")

    tmr.delay(200000)
    tmr.delay(200000)
    tmr.delay(200000)
    tmr.delay(200000)
    tmr.delay(200000)

	print ("logging...");

    file.open("log.txt", "a")

	-- read DHT22 Sensor
	status,temp,humi,temp_decimial,humi_decimial = dht.read(DHT_Pin)
	
	-- read BH1750 Sensor
	bh1750 = require("bh1750")
	bh1750.init(SDA_PIN, SCL_PIN)
	bh1750.read()
	lux = bh1750.getlux()
    lux2 = bh1750.getlux2()
    lux3 = bh1750.getlux3()
	bh1750 = nil
	package.loaded["bh1750"]=nil

	--read BMP180 Sensor
	bmp180 = require("bmp180")
	bmp180.init(SDA_PIN, SCL_PIN)
	bmp180.read(BMP180_OSS)
	t = bmp180.getTemperature()
	p = bmp180.getPressure()

	--print the values for debugging and testing
    print(string.format("DHT Temperature: %.1f deg C", temp))
    print(string.format("DHT Humidity:    %.1f rH", humi))
    print(string.format("Brightness:      %.1f lx", (lux)))
    print(string.format("Brightness2:      %.1f lx", (lux2)))
    print(string.format("Brightness3:      %.1f lx", (lux3)))
    print(string.format("Temperature:     %.1f deg C",(t/10)))
    print(string.format("Pressure:        %.1f mbar",(p / 100)))

    file.writeline(string.format("%d,%.1f,%.1f,%.1f,%.1f,%.1f,%.1f,%.1f,%d",tmr.now(),temp,humi,lux, lux2, lux3, (t/10), (p / 100),node.heap()))

    file.flush()
    
    file.close()   

	gpio.write(LED_Pin, 1)

	collectgarbage();
  
end
--run the posting funcion once
--Test()
-- start Timer to send data every 60 sec
tmr.alarm(2, 60000, 1, function() Test() end )
