#include <Servo.h>


//#define SETUP0      // set all to 0 degree
//#define SETUP1      // all count 0..9

OneWire oneWire(2);          // Setup a oneWire instance to communicate with any OneWire devices. Data wire is plugged into port 2 on the Arduino
DallasTemperature sensors(&oneWire);    // Pass our oneWire reference to Dallas Temperature. 

Servo sec_1_1;              // Erste 7 Segment Anzeige Servo 1
Servo sec_1_2;             // Erste 7 Segment Anzeige Servo 2
Servo sec_1_3;            // Erste 7 Segment Anzeige Servo 3
Servo sec_1_4;          // Erste 7 Segment Anzeige Servo 4

// Servo setup in degree for each value 0..9
// array of digits 0..3
// Servo setup 0,90,180 Grad. Manchmal ist eine kleine Anpassung nötig
uint8_t Digit1[4][10]={  {85,5,5,5,85,85,85,5,85,85},           // Servo 1
                         {90,190,0,90,190,0,0,90,90,90},        // Servo 2
                         {160,160,0,75,75,75,75,160,75,75},     // Servo 3
                         {180,0,180,80,0,80,180,0,180,80} };    // Servo 4
uint8_t Digit2[4][10]={  {90,5,5,5,90,90,90,5,90,90},
                         {85,176,0,85,176,0,0,85,85,85},
                         {170,170,4,85,85,85,85,170,85,85},
                         {180,0,180,75,0,75,180,0,180,75} };
uint8_t Digit3[4][10]={  {90,5,5,5,90,90,90,5,90,90},
                         {85,190,5,85,190,5,5,85,85,85},
                         {180,180,1,75,75,75,75,180,75,75},
                         {175,5,175,90,5,90,175,5,175,90} };
uint8_t Digit4[4][10]={  {90,1,1,1,90,90,90,1,90,90},
                         {90,175,2,90,175,2,2,90,90,90},
                         {180,180,4,89,89,89,89,180,89,89},
                         {180,1,180,85,1,85,180,1,180,85} };

uint8_t Digit3DegreeSign[4] = {90, 2, 1, 5};

//uint8_t slowdown = 5;  // ms um Servo Geschwindigkeit (und Geräuschpegel) zu reduzieren

// Zuordnung der Servos zu Pins
uint8_t SERVO1 = 11;
uint8_t SERVO2 = 10;
uint8_t SERVO3 = 9;
uint8_t SERVO4 = 6;

// Zuordnung der Ziffernposition zu Pinadressen. Bei Analog-Pins muss die digitale zaehlweise benutzt werden
uint8_t ZIFFER1 = 14;   // A0
uint8_t ZIFFER2 = 15;   // A1
uint8_t ZIFFER3 = 16;
uint8_t ZIFFER4 = 17;

uint16_t WECHSELINTERVALL = 5000;

// Settings for RTC DS3231:
#define RTC_I2C_ADDRESS 0x68      // I2C Adresse des RTC  DS3231
struct Rtc
{
  uint8_t jahr,monat,tag,stunde,minute,sekunde,wochentag;
};
Rtc zeit;

byte decToBcd(byte);
byte bcdToDec(byte);
void rtcReadTime();
void rtcWriteTime(int, int, int, int, int, int);
void ShowTime ();
void ShowTemp (double);
void ShowNumber (int16_t);
void ServosShowValue (uint8_t, uint16_t);
void ServosGoDegree (uint8_t, uint8_t, uint8_t, uint8_t, uint8_t);




