#!/usr/bin/env python

# Cameralucida.py

# Die naechsten 4 Zeilen holen (importieren) Python-Bibliotheken und Funktionen

# fuer die Kamera
from picamera import PiCamera

# fuer die Verzoegerungspause:
from time import sleep
import time

# fuer die Steuerung der Raspberry-Anschluesse
import pigpio

# Nun legen wir fest, welcher Anschluss-Pin wofuer benutzt wird:

#fuer die Steuerung des Schalttransistors der LED-Leiste:
LED=18
# Fuer den Taster zur Erhoehung der Helligkeit:
Heller=27

# Fuer den Taster zum Verdunkeln:
Dunkler=17

# Fuer den Taster, der das Kamerabild auf dem Bildschirm ein- oder ausschaltet:
CamOnOff=22

# Unter dem Namen 'camera' sprechen wir von nun an die Kamera an:
camera = PiCamera()

# Hier folgt die Namensfestlegung fuer die PIN-Steuerung:
pi = pigpio.pi()

# Der Anschluss fuer die LED-Leiste wird zum Ausgang (output) erklaert:
pi.set_mode(LED, pigpio.OUTPUT)

# Die Anschluesse fuer die Taster hingegen werden Eingaenge (input):
pi.set_mode(Heller, pigpio.INPUT)
pi.set_mode(Dunkler, pigpio.INPUT)
pi.set_mode(CamOnOff, pigpio.INPUT)

# Die Startwerte festlegen fuer
#Helligkeit:
pwm = 0
# Schrittweite beim Veraendern der Helligkeit:
step = 8
# Soll die Kamera eingeschaltet (1) oder ausgeschaltet (-1) werden?
cam = 1
# War die Kamera zuvor eingeschaltet (1) oder nicht (0)?
lastcam = 0

# Und nun beginnt die Hauptschleife des Programms:
while True:

# Wurde der Kamerataster gedrueckt?
   if pi.read(CamOnOff) < 1:
      # wenn ja, dann wechsle den Zustand von cam!
      cam = cam *(-1)
      
# Soll die Kamera eingeschaltet werden (cam = 1)?      
   if cam > 0:
      # Wenn Ja, war die Kamera ausgeschaltet?
      if lastcam < 1:
         # dann schalte sie ein
         camera.start_preview()
         # und merke dir, dass sie eingeschaltet ist
         lastcam = 1

# Soll die Kamera ausgeschaltet werden (cam = -1)      
   if cam < 0:
      # dann schalte die Kamera aus
      camera.stop_preview()
      # und merke dir, dass sie ausgeschaltet ist
      lastcam = 0

# Setze die Helligkeit der LED auf den aktuellen Wert
   pi.set_PWM_dutycycle(LED, pwm)

# Ist der Heller-Taster gedrueckt
   if pi.read(Heller) < 1:
      # Falls ja, erhoehe den Helligkeitswert um die gewuenschte Schrittweite
      pwm = pwm + step
# Ist die Helligkeit groesser als erlaubt (max. 255)?      
   if pwm > 255:
      # Falls Ja, setze sie auf 255 zurueck
      pwm = 255
# Ist der Dunkler-Taster gedrueckt?      
   if pi.read(Dunkler) < 1:
      # Falls ja, verringere die Helligkeit um die gewuenschte Schrittweite
      pwm = pwm - step
# Ist die Helligkeit kleiner als erlaubt (min. 0)?
   if pwm < 0:
      # Falls Ja, setze die Helligkeit auf 0
      pwm = 0

   try:
      # Warte 0,2 Sekunden, bevor der naechste Schleifendurchlauf beginnt
      time.sleep(0.2)

      # Wurde Strg + C gedrueckt (fuer Programmabbruch)?
   except KeyboardInterrupt:
      
      # Falls Ja, dann stoppe das Kamerabild
      # (falls nicht, beginne die Programmschleife hinter "while" erneut)
      camera.stop_preview()
      # und schalte die LED ab
      pi.set_PWM_dutycycle(LED, 0)
      # und stoppe die Steuerung der Anschluesse
      pi.stop()
      # und beende die Programmschleife
      break
# Steig aus dem Programm aus   
exit(0)
   

   
