//////////////////////////////////////////////////////////////////////////////
// Steuerung der Laser
// Wird nur ein Laser verwendet, so muss die Zeile   "#define Farblaser true"
// nach "#define Farblaser false" geändert werden.
//
// Ulrich Schmerold
// 10/2017
// veröffentlicht in der MAKE 6/2017
//////////////////////////////////////////////////////////////////////////////

#define Farblaser true

int laser_pin_r=39; // Pin, an dem der rote Laser angeschlossen ist
int laser_pin_g=43; // Pin, an dem der grüne Laser angeschlossen ist
int laser_pin_b=41; // Pin, an dem der blaue Laser angeschlossen ist

void init_Laser()               // alle Laserpins als Output definieren
{
  pinMode(laser_pin_r, OUTPUT);
  pinMode(laser_pin_g, OUTPUT);
  pinMode(laser_pin_b, OUTPUT);
}


void rgb_laser(boolean r, boolean g, boolean b) // Laser schalten
{                                               // Farben werden als Einzelwerte angegeben
  digitalWrite(laser_pin_r, r);
  digitalWrite(laser_pin_g, g);
  digitalWrite(laser_pin_b, b);
}


void RGBLaser(byte Color)                 // Laser schalten    
{                                         // Farbe als Binaerwert angeben
  if (Farblaser == true)                  // Unterscheidung ob Farblaser oder monochrom Laser
  {
    digitalWrite(laser_pin_r, Color & 1);   // 0 = Laser aus
    digitalWrite(laser_pin_g, Color & 2);   // 1 = Rot,  2 = Gruen, 4 = Blau, 7 = Weiss
    digitalWrite(laser_pin_b, Color & 4);   // 3 = Mischfarbe aus Rot und  Grün ...usw.
  } else if ((Color == 0) or (Color == 128)) 
    digitalWrite(laser_pin_r,0);  else digitalWrite(laser_pin_r,1);  
}

void laser_on() // alle Laser einschalten
{
  RGBLaser(7);
}


void laser_off() // alle Laser ausschalten
{
  RGBLaser(0);
}



