# -*- coding: utf-8 -*-
import cv2
from flask import Flask, Response
import numpy as np
import thread
import time

class stream:
  
  def __init__(self):
    # Beide Kameras initialisieren:
    self.videoL = cv2.VideoCapture(0)       
    self.videoL.set(3, 640)
    self.videoL.set(4, 360)

    self.videoR = cv2.VideoCapture(1)       
    self.videoR.set(3, 640)
    self.videoR.set(4, 360)

  def get_frame(self):
    while True:
      successL, imageL = self.videoL.read()
      successR, imageR = self.videoR.read()
      
      # Falls das Auslesen beider Kamerabilder geklappt hat,
      # werden die Bilder zu einem Frame zusammengesetzt...
      if (successL and successR):
        image = np.concatenate((imageL, imageR), axis=1)
      else:
        # ...sonst wird ein schwarzes Frame zurckgegeben.
        image = np.zeros((360, 1280, 3), np.uint8)
            
      ret, jpeg = cv2.imencode('.jpg', image)
      return jpeg.tobytes()

  def gen(self):
    while True:
      frame = self.get_frame()
      yield (b'--frame\r\n' + b'Content-Type: image/jpeg\r\n\r\n' + frame + b'\r\n\r\n')
  
  def startStream(self):
    thread.start_new_thread(self.run, ())

  def run(self):
    app = Flask('3dCam')
    @app.route('/videoFeed')
    def video_feed():
      return Response(self.gen(), mimetype='multipart/x-mixed-replace; boundary=frame')
    
    # Falls der Client abbricht und der Server stoppt, wird er wieder neu gestartet:
    try:
      app.run(host='0.0.0.0', port=8080, debug=False)
    except:
      self.run()

videostream = stream()
videostream.startStream()

while True:
  time.sleep(10)