//define size of battery module:
//lay module flat on table, contacts facing to you, then
//B is the dimension from left to right,
//L is the dimension away from you.
//define the position of the electrical contacts (center):
//Xn is the distance from right corner in horizontal and
//Yn is the distance from table top in vertical direction.
//  note: always use #1, #3 near edges and #2 between.
//pindia is the outer diameter and
//pinlen is the length of the spring contact (pogo stick),
//  measured when in contact with the module.

//e.g. Sony NP-400:
text = "9V E block";
font = "Arial";
B=27;     //width                                          (39.6)
L=50;     //length                                         (56.8)
X1=7;     //horizontal position contact #1 (left)           (4.0)
Y1=8.25;  //vertical position contact #1                    (2.5)
X2=13;    //horizontal position contact #2                 (22.0)
Y2=8.25;  //vertical position contact #2                    (2.5) 
X3=20;    //horizontal position contact #3                 (35.6)
Y3=8.25;     //vertical position contact #3   (right)          (2.5)
pindia=1.3; //diameter of spring contact (pogo stick)         (1.3)
pinlen=29;  //length of spring contact protruding from module(23.0)

//do not change!
th_plate=1.5;     //thickness of bottom plate under module    (1.5)
th_wall=2;        //thickness of sidewalls and front hook     (2.0)
h_wall=4.5;       //height of walls and hook over base plate  (4.5)
wd_link=5;        //width of back link between blocks         (5.0)

difference() {
     union() {
    
    //sidewall left
    translate([-B/2-th_wall, -L, 0])
    cube([th_wall,L,th_plate+h_wall]); 
    //sidewall right
    translate([B/2, -L, 0])
    cube([th_wall,L,th_plate+h_wall]);  
    //bottom plate
    translate([-B/2, -L, 0])
    cube([B,L,th_plate]);
    //front hook
    translate([-50, -L-th_wall, 0])
    cube([100,th_wall,th_plate+h_wall]);
    //back block left
    translate([-B/2-th_wall, 0, 0])
    cube([th_wall+X1+pindia+1,pinlen+0.5,th_plate+Y1+1.5]);
    //fixings left
    translate([-B/2+X1-(pindia+2)/2, 5, th_plate+Y1+1.5])
    cube([pindia+2,2,1]);
    translate([-B/2+X1-(pindia+2)/2, pinlen/1.4-2, th_plate+Y1+1.5])
    cube([pindia+2,2,1]);
    //back block center
    //translate([-B/2+X2-(pindia+4)/2, 0, 0])
    //cube([pindia+4,pinlen+0.5,th_plate+Y2+1.5]);
    //fixings center
    //translate([-B/2+X2-(pindia+2)/2, 5, th_plate+Y1+1.5])
    //cube([pindia+2,2,1]);
    //translate([-B/2+X2-(pindia+2)/2, pinlen/1.4-2, th_plate+Y1+1.5])
    //cube([pindia+2,2,1]);
    //back block right         
    translate([B/2-(B-X3)-pindia-1, 0, 0])
    cube([(B-X3)+pindia+1+th_wall,pinlen+0.5,th_plate+Y3+1.5]);
    //fixings right
    translate([B/2-(B-X3)-(pindia+2)/2, 5, th_plate+Y1+1.5])
    cube([pindia+2,2,1]);
    translate([B/2-(B-X3)-(pindia+2)/2, pinlen/1.4-2, th_plate+Y1+1.5])
    cube([pindia+2,2,1]);
    //link
    translate([-B/2, pinlen-wd_link+0.5, 0])
    cube([B,wd_link,th_plate+1]);
    //fixings for resistor
    //translate([-B/2+X1+pindia+3, (pinlen+0.5)-2, th_plate+1])
    //cube([2,2,2]);
    //translate([-B/2+X1+pindia+3, (pinlen+0.5)-5, th_plate+1])
    //cube([2,2,2]);
    //polarity guide
    translate([-B/2, -3, th_plate])
    cube([B,3,Y3]);
 
           } //union end
    
    //engrave text
    //translate([-10, -20, th_plate-0.2])
    //linear_extrude(height = 0.5) {
    //text(text = str(text), font = font, size = 3, valign = 0);}
    //cutout left
    translate([-36-B/2, -7-L, -0.1])
    cylinder(d=90,h=2*h_wall+th_plate, $fn=128);
    //cutout center
    translate([0, -21, -0.1])
    cylinder(d=18,h=2*h_wall+th_plate, $fn=128);
    //cutout center front
    translate([0, -38, -0.1])
    cylinder(d=8,h=2*h_wall+th_plate, $fn=128);     
    //cutout right
    translate([36+B/2, -7-L, -0.1])
    cylinder(d=90,h=2*h_wall+th_plate, $fn=128);
    //vertical connector hole left
    translate([-B/2+X1, pinlen-2, -0.1])
    cylinder(d=3,h=22, $fn=32);
    //pin hole left
    translate([-B/2+X1-pindia/2, -0.1, th_plate+Y3-pindia/2])
    cube([pindia+0.15, pinlen-2, 6]);
    //polarity guide cutout left (pos)
    translate([B/2-X3, 0.1, th_plate+Y3])
    rotate([90, 0, 0])
    cylinder(d=7, h=10, $fn=32);
    //vertical connector hole center
    translate([-B/2+X2, pinlen-2, -0.1])
    cylinder(d=3,h=22, $fn=32);
    //pin hole center
    //translate([-B/2+X2-pindia/2, -0.1, th_plate+Y2-pindia/2])
    //cube([pindia+0.15, pinlen-2, 6]);
    //vertical connector hole right
    translate([-B/2+X3, pinlen-2, -0.1])
    cylinder(d=3,h=22, $fn=32);
    //pin hole right
    translate([-B/2+X3-pindia/2, -0.1, th_plate+Y1-pindia/2])
    cube([pindia+0.15, pinlen-2, 6]);
    //polarity guide cutout right (neg)
    translate([B/2-X1, 0.1, th_plate+Y1])
    rotate([90, 0, 0])
    cylinder(d=9, h=10, $fn=32);
    //bolt sinks
    translate([-9, -8, -0.1])
    cylinder(d1=2.5,d2=6.5,h=2, $fn=32);
    translate([9, -8, -0.1])
    cylinder(d1=2.5,d2=6.5,h=2, $fn=32);
    //cable cutouts
    translate([-B, 6, -0.1])
    rotate([0, 90, 0])
    cylinder(d=10,h=150, $fn=32);    
    //translate([-B, 9, -0.1])
    //rotate([0, 90, 0])
    //cylinder(d=5,h=150, $fn=32);
    translate([-B, 18, -0.1])
    rotate([0, 90, 0])
    cylinder(d=10,h=150, $fn=32);
    //vertical cutouts
    translate([B/2+th_wall, 6, -0.1])
    cylinder(d=10,h=50, $fn=32);
    translate([-B/2-th_wall, 6, -0.1])
    cylinder(d=10,h=50, $fn=32); 
    translate([B/2+th_wall, 30, -0.1])
    cylinder(d=10,h=50, $fn=32);
    translate([-B/2-th_wall, 30, -0.1])
    cylinder(d=10,h=50, $fn=32);
    translate([B/2+th_wall, 18, -0.1])
    cylinder(d=10,h=50, $fn=32);
    translate([-B/2-th_wall, 18, -0.1])
    cylinder(d=10,h=50, $fn=32);  
    //horizontal slope left
    translate([-B/2-th_wall, -0.1, 11])
    rotate([-90, 0, 0])
    cylinder(d=12,h=150, $fn=32);
    //horizontal slope right
    translate([B/2+th_wall, -0.1, 11])
    rotate([-90, 0, 0])
    cylinder(d=12,h=150, $fn=32);
  
           }   //difference end
