#include <VGAX.h>

const float MIN_RE = -2.5;
const float MAX_RE = 1.0;
const float MIN_IM = -1.2;
const float MAX_IM = 1.2;
  
VGAX vga;

void setup() {
  vga.begin();
}

void loop() {
  for (uint8_t y = 0; y < VGAX_HEIGHT; y++) {
    float im = MIN_IM + y * (MAX_IM - MIN_IM) / VGAX_HEIGHT;
    for (uint8_t x = 0; x < VGAX_WIDTH; x++) {
      float re = MIN_RE + x * (MAX_RE - MIN_RE) / VGAX_WIDTH;
      float tr = re;
      float ti = im;

      uint8_t depth = 0;
      while (depth++ < 20) {
        float temp = tr * tr - ti * ti + re;
        ti = 2 * tr * ti + im;
        tr = temp;
        if (tr * tr + ti * ti > 4)
          break;
      }
      if (depth < 4)
        vga.putpixel(x, y, 3);
      else if (depth < 8)
        vga.putpixel(x, y, 2);
      else if (depth < 16)
        vga.putpixel(x, y, 1);
    }
  }
}

