#include "VGAX.h"

#define VSYNCPIN 9

void VGAX::begin() {
  cli(); // Alle Interrupts abschalten.

  // TIMER1 erzeugt VSYNC-Signal.
  pinMode(VSYNCPIN, OUTPUT);
  TCCR1A = bit(WGM11) | bit(COM1A1);
  TCCR1B = bit(WGM12) | bit(WGM13) | bit(CS12) | bit(CS10); // Prescaler 1024
  ICR1 = 259; // 16666 / 64 uS = 260 (minus 1)
  OCR1A = 0; // 64 / 64 uS = 1 (minus 1)
  TIFR1 = bit(TOV1); // Overflow-Flag löschen
  TIMSK1 = bit(TOIE1); // Interrupt bei Überlauf von TIMER1

  sei(); // Alle Interrupts einschalten.
}

ISR(TIMER1_OVF_vect) {
}
