#include <SD.h>

const uint16_t BAUD_RATE = 9600;
const uint8_t CHIP_SELECT_PIN = 10;
const char DATEI_NAME[] = "test.wav";

void setup() {
  Serial.begin(BAUD_RATE);

  for (uint8_t i = 0; i < 8; i++)
    pinMode(i, OUTPUT);
  
  if (!SD.begin(CHIP_SELECT_PIN)) {
    Serial.println("SD-Karte konnte nicht initialisiert werden.");
    return;
  }

  File audioDatei = SD.open(DATEI_NAME);
  if (!audioDatei) {
    Serial.println("Die Audio-Datei konnte nicht geöffnet werden.");
  } else {
    while (audioDatei.available()) {
      PORTD = audioDatei.read();
      delayMicroseconds(60);
    }
    audioDatei.close();
  }
}

void loop() {}

