
//Einbinden der Servo-Bibliothek
#include <Servo.h>
Servo AnzeigeServo;

//Die Arrays VorratNullbisFuenf[6] und ZufallszahlenSymbolAuswahl[6] werden angelegt. Sie 
//sind sind fuer die Erzeugung und Speicherung von sechs unterschiedlichen Zufallszahlen notwendig
int VorratNullbisFuenf[6];
int ZufallszahlenSymbolAuswahl[6];  

//In den Arrays SymboleLedOben[6], SymboleLedLinks[6], SymboLedRechts[6]
//sollen die 6 im Laserzielgerät verwendeten (jeweils aus drei Led's bestehenden)
//Symbole abgespeichert werden             
boolean SymboleLedOben[6];              
boolean SymboleLedLinks[6];            
boolean SymboleLedRechts[6]; 

//In den Arrays ZieleDigPinsLedOben[6], ZieleDigPinsLedLinks[6], ZieleDigPinsLedRechts[6]
//sollen die Arduino-Digitalpins, mit denen die Led's auf den Zielscheiben
//verbunden sind, gespeichert werden
int ZieleDigPinsLedOben[6];          
int ZieleDigPinsLedLinks[6];         
int ZieleDigPinsLedRechts[6];   

//In den Arrays ZieleAuswahlDigPinsLedOben[6], ZieleAuswahlDigPinsLedLinks[6], 
//ZieleAuswahlDigPinsLedRechts[6] sollen die Arduino-Digitalpins, 
//mit denen die Led's auf den Zielauswahlscheiben verbunden sind, gespeichert werden
int ZieleAuswahlDigPinsLedOben[6];   
int ZieleAuswahlDigPinsLedLinks[6]; 
int ZieleAuswahlDigPinsLedRechts[6]; 

//In dem Array ZieleAnalogPins[] sollen die Arduino-Analogpins, mit denen die Lichtsensoren
//auf den Zielscheiben verbunden sind, gespeichert werden
int ZieleAnalogPins[7];

//Die Nummer der Zielscheibe, die getroffen werden soll 
int Ziel;
//Symbol, dass auf der verzoegert aufleuchtenden Zielauswahlscheibe erscheinen soll, 
//identisch mit dem Symbol auf der ausgewaehlten Zielscheibe
int Zielsymbol; 


void setup()
{
  //Hier wird die Referenzspannung fuer die Analogeingaenge konfiguriert
  //(5V fuer Arduini MEGA) und ein AnalogPin fuer randomSeed reserviert
  analogReference(DEFAULT); 
  randomSeed(analogRead(7));
  
  //Hier wird der AnzeigeServo mit dem Digital-PWM-Pin 3 verknuepft und auf Null gestellt.
  //Anschliessend wird die "Einschwingzeit" des Servos  abgewartet
  AnzeigeServo.attach(3);  
  AnzeigeServo.write(180);   
  delay(1000);              
 
  //Digitale Pins fuer die Dioden (außer Betriebsanzeige) werden als 
  //Ausgaenge deklariert und auf LOW gesetzt
  for (int i=4; i<13; i++) pinMode(i,OUTPUT);    
  for (int i=22; i<49; i++)pinMode(i,OUTPUT);    
  for (int i=4; i<13; i++) digitalWrite(i,LOW);  
  for (int i=22; i<49; i++)digitalWrite(i,LOW);   

  //Die Betriebsanzeige wird angeschaltet
  pinMode(2,OUTPUT);    
  digitalWrite(2,HIGH);
  
  //Die Arrays SymboleLedOben[], SymboleLinks[], SymboleLedRechts[] werden 
  //mit Boolean-Werten gefuellt
  SymboleLedOben[0]=HIGH;   
  SymboleLedOben[1]=LOW;
  SymboleLedOben[2]=HIGH;
  SymboleLedOben[3]=HIGH;
  SymboleLedOben[4]=LOW;
  SymboleLedOben[5]=HIGH;

  SymboleLedLinks[0]=LOW;   
  SymboleLedLinks[1]=HIGH;
  SymboleLedLinks[2]=HIGH;
  SymboleLedLinks[3]=LOW;
  SymboleLedLinks[4]=HIGH;
  SymboleLedLinks[5]=HIGH;

  SymboleLedRechts[0]=LOW;   
  SymboleLedRechts[1]=LOW;
  SymboleLedRechts[2]=LOW;
  SymboleLedRechts[3]=HIGH;
  SymboleLedRechts[4]=HIGH;
  SymboleLedRechts[5]=HIGH;

  //In die Arrays ZieleDigPinsLedOben[6], ZieleDigPinsLedLinks[6], ZieleDigPinsLedRechts[6]
  //werden die Arduino-Digitalpins eingegeben, mit denen die Led's auf den Zielscheiben
  //verbunden sind.
  ZieleDigPinsLedOben[0]=31;    
  ZieleDigPinsLedOben[1]=34;
  ZieleDigPinsLedOben[2]=37;
  ZieleDigPinsLedOben[3]=40;
  ZieleDigPinsLedOben[4]=43;
  ZieleDigPinsLedOben[5]=46;

  ZieleDigPinsLedLinks[0]=32;   
  ZieleDigPinsLedLinks[1]=35;
  ZieleDigPinsLedLinks[2]=38;
  ZieleDigPinsLedLinks[3]=41;
  ZieleDigPinsLedLinks[4]=44;
  ZieleDigPinsLedLinks[5]=47;

  ZieleDigPinsLedRechts[0]=33;    
  ZieleDigPinsLedRechts[1]=36;
  ZieleDigPinsLedRechts[2]=39;
  ZieleDigPinsLedRechts[3]=42;
  ZieleDigPinsLedRechts[4]=45;
  ZieleDigPinsLedRechts[5]=48;

  //In die Arrays ZieleAuswahlDigPinsLedOben[6], ZieleAuswahlDigPinsLedLinks[6], 
  //ZieleAuswahlDigPinsLedRechts[6]werden die Arduino-Digitalpins eingegeben, 
  //mit denen die Led's auf den Zielauswahlscheiben verbunden sind.
  ZieleAuswahlDigPinsLedOben[0]=4;    
  ZieleAuswahlDigPinsLedOben[1]=7;
  ZieleAuswahlDigPinsLedOben[2]=10;
  ZieleAuswahlDigPinsLedOben[3]=22;
  ZieleAuswahlDigPinsLedOben[4]=25;
  ZieleAuswahlDigPinsLedOben[5]=28;

  ZieleAuswahlDigPinsLedLinks[0]=5;    
  ZieleAuswahlDigPinsLedLinks[1]=8;
  ZieleAuswahlDigPinsLedLinks[2]=11;
  ZieleAuswahlDigPinsLedLinks[3]=23;
  ZieleAuswahlDigPinsLedLinks[4]=26;
  ZieleAuswahlDigPinsLedLinks[5]=29;

  ZieleAuswahlDigPinsLedRechts[0]=6;   
  ZieleAuswahlDigPinsLedRechts[1]=9;
  ZieleAuswahlDigPinsLedRechts[2]=12;
  ZieleAuswahlDigPinsLedRechts[3]=24;
  ZieleAuswahlDigPinsLedRechts[4]=27;
  ZieleAuswahlDigPinsLedRechts[5]=30;

  //In das Array ZieleAnalogPins[] werden die Arduino-Analogpins aufgelistet, mit denen die Lichtsensoren
  //auf den Zielscheiben verbunden sind.
  ZieleAnalogPins[0]= 0;
  ZieleAnalogPins[1]= 1;
  ZieleAnalogPins[2]= 2;
  ZieleAnalogPins[3]= 3;
  ZieleAnalogPins[4]= 4;
  ZieleAnalogPins[5]= 5;

  //Das Umgebungslicht wird gemessen. Wenn es zu hell ist, blinkt die Betriebsanzeige 
  //und es ertönt ein Warnton
  int Lichtmessung = analogRead(6);
  while (Lichtmessung > 900)
  { 
    digitalWrite(2,LOW);
    tone(13,1000,50); //hängt am PWM-Pin13, Frequenz 1000Hz, Tondauer 100ms
    delay(50);
    tone(13,900,50);
    delay(50);
    tone(13,800,50);
    delay(50);
    delay(850);
    digitalWrite(2,HIGH);
    delay(1000);
    Lichtmessung = analogRead(6);
  }

  //Warteschleife, bis die ZielscheibeStart getroffen wird. Nach einem Treffer wird ein Quittungston erzeugt
  int Delta = 0;
  int Lichtmessung1 = analogRead(6);
  int Lichtmessung2 = 0;;
  while (Delta <50)
  { 
    Lichtmessung2 = analogRead(6);
    Delta = abs(Lichtmessung2-Lichtmessung1);
  }
  int i = 0;
  while (i < 20) 
  {
    tone(13,1000,50);
    delay(50);
    tone(13,800,50);
    delay(50);
    i++;
  } 
}
  

void loop()
{ 
  //Alle Dioden (außer der Betriebsanzeige) werden auf LOW gesetzt
  for (int i=4; i<13; i++) digitalWrite(i,LOW);
  for (int i=22; i<49; i++)digitalWrite(i,LOW);  
    
  //Der AnzeigeServo wird auf Null gefahren und anschliessend wird die 
  //Einschwingzeit des Servos abgewartet
  AnzeigeServo.write(180);  
  delay(1000); 

  //Das Array VorratNullbisFuenf[] wird mit den Zahlen 0, 1, ... , 5 
  //gefuellt und in alle Zellen des Arrays ZufallszahlenSymbolAuswahl[] 
  //wird die Zahl 6 eingetragen. 6 bedeutet, dass diese Zelle noch 
  //nicht mit einer Zufallszahl "befuellt" ist
  for (int i=0; i<6; i++)
   {
    VorratNullbisFuenf[i] = i;
    ZufallszahlenSymbolAuswahl[i] = 6;
   }

  //Hier wird das Array ZufallszahlenSymbolAuswahl[] mit sechs 
  //unterschiedlichen Zufallszahlen gefuellt
  int i = 0;
  do
    {
     int ZufallszahlSymbol = random(6);
     if (ZufallszahlenSymbolAuswahl[ZufallszahlSymbol]==6) //d.h. die Zelle ist noch nicht belegt!
      {
        ZufallszahlenSymbolAuswahl[ZufallszahlSymbol]= VorratNullbisFuenf[i];
        i++;
      }
    }
  while(i<6);

  //Sechs unterschiedliche Symbole werden auf den sechs Zielscheiben erzeugt
  int ZufallszahlZiel = random(6); 
  for (int i=0; i<6; i++)
  {
    int ZufallszahlSymbol = ZufallszahlenSymbolAuswahl[i];   
    digitalWrite(ZieleDigPinsLedOben[i], SymboleLedOben[ZufallszahlSymbol]);
    digitalWrite(ZieleDigPinsLedLinks[i], SymboleLedLinks[ZufallszahlSymbol]);
    digitalWrite(ZieleDigPinsLedRechts[i], SymboleLedRechts[ZufallszahlSymbol]);
    if (ZufallszahlZiel == i) 
      {
        Ziel = i;   
        Zielsymbol  = ZufallszahlSymbol; 
      }
  }

  //Hier wird eine Verzoegerung von 1000ms, 2000ms, 3000ms, 4000ms, 5000ms, 6000ms oder 7000ms
  //erzeugt
  int ZufallszahlVerzoegerung=1000+1000*random(7);
  delay(ZufallszahlVerzoegerung); 

  //Eine Zielauswahlscheibe wird gewaehlt und mit einem Symbol versehen
  int ZufallszahlZielauswahl = random(6); //für Zufallsauswahl der Zielauswahlscheibe 
  digitalWrite(ZieleAuswahlDigPinsLedOben[ZufallszahlZielauswahl], SymboleLedOben[Zielsymbol]);
  digitalWrite(ZieleAuswahlDigPinsLedLinks[ZufallszahlZielauswahl], SymboleLedLinks[Zielsymbol]);
  digitalWrite(ZieleAuswahlDigPinsLedRechts[ZufallszahlZielauswahl], SymboleLedRechts[Zielsymbol]);

  //Die Zeit (Reaktionszeit) zwischen dem Aufleuchten eines Symbols auf der Zielauswahlscheibe und 
  //einem Treffer auf der entsprechenden Zielscheibe wird ermittelt
  long Startzeit = millis(); 
  int Delta = 0;
  int Lichtmessung1 = analogRead(Ziel);
  int Lichtmessung2 = 0;
  while (Delta <50)
  { 
    Lichtmessung2 = analogRead(Ziel);
    Delta = abs(Lichtmessung2-Lichtmessung1);
  }
  long Reaktionszeit = millis() - Startzeit;

  //Die Anzeige der Reaktionszeit mit Hilfe des AnzeigeServos wird durchgefuehrt. Ferner wird  
  //ein Quittungston erzeugt
  long Grad = 180-((152*Reaktionszeit)/8000);          
  if (Reaktionszeit >= 8000) Grad = 20;      
  AnzeigeServo.write(Grad); 
  i = 0;
  while (i < 20) 
  {
    tone(13,1000,50);
    delay(50);
    tone(13,800,50);
    delay(50);
    i++;
  }            
                        
  //Warteschleife, bis ueber die ZielscheibeStart eine weitere Reaktionszeitmessung angefordert wird
  Delta = 0;
  Lichtmessung1 = analogRead(6);
  Lichtmessung2 = 0;;
  while (Delta <50)
  { 
    Lichtmessung2 = analogRead(6);
    Delta = abs(Lichtmessung2-Lichtmessung1);
  }
}



