//////////////////////////////////////////////////////////////////////////////
// Zeitlupenrahmen 
//
// Adaption des SlowDance-Projekts von Jeff Liebermann
//
// Der Magnet muss an den Pin 3 und der LED-Stripe an den Pin 10 angeschlossen werden. Nicht verändern!!!
//
// Ulrich Schmerold
// 12/2017
//
// Code und Schaltung sind abgeleitet von:
// TimeFrame V3.0
// Copyright (C) 2016 Cubc-Print
// get the latest source core here: http://www.github.com/cubic-print/timeframe
// video: http://youtu.be/LlGywKkifcI
// order your DIY kit here: http://www.cubic-print.com/TimeFrame
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    GNU General Public License terms: <http://www.gnu.org/licenses/>.
//////////////////////////////////////////////////////////////////////////////

#define MIN_PHASE_SHIFT -2.0 // minimale Phasenverschiebung (Bewegung rückwärts)
#define MAX_PHASE_SHIFT 2.0  // maximale Phasenverschiebung (Bewegung vorwärts)
#define MIN_FREQ 65.0        // minimale Frequenz des Elektromagneten
#define MAX_FREQ 100.0       // maximale Frequenz des Elektromagneten
#define MIN_STRENGTH 5.0     // Mimimalstärke des Elektromagneten
#define MAX_STRENGTH 25.0    // Maximalstärke vom Elektromagneten
#define DUTY_LED 20.0
  
 
void setup() {
  pinMode(A0, INPUT); // Frequenz Elektromagnet
  pinMode(A1, INPUT); // Phasenverschiebung (Time Shift)
  pinMode(A2, INPUT); // Anzugdauer des Magneten
  pinMode(3, OUTPUT); // Pin 3 als Output (Elektromagnet)
  pinMode(10, OUTPUT);// Pin 10 als Output (LED-Stripe)

  Set_Register();
}

void loop() { 
  
  // Hier wird aus dem Analogwert A1 und oben definierten Grenzen die Phasenverschiebung errechnet.
  float phase_shift = (MAX_PHASE_SHIFT - MIN_PHASE_SHIFT) / 1023 * analogRead(A1) - MAX_PHASE_SHIFT; 

  // Hier wird aus dem Analogwert A0 und den oben definierten Grenzen die Elektromagnet-Frequenz errechnet.
  float  frequenz_mag = (MAX_FREQ - MIN_FREQ) / 1023 * analogRead(A0) + MIN_FREQ;  
  
  // Fehlt noch die Anzugdauer des Elektromagneten, die aus A2 beerechnet wird.
  float duty_mag = MAX_STRENGTH -(MAX_STRENGTH - MIN_STRENGTH) / 1023 * analogRead(A2);  

  // Die Frequenz der LED errechnet sich aus der Magnetfrequenz und der Phasenverschiebung.
  float frequency_led = frequenz_mag + phase_shift;

  long time_mag = round(16000000 / 1024 / frequenz_mag); 
  long time_led = round(16000000 / 8 / frequency_led);

  OCR2A = round(time_mag);                   // Setzen des Output Compare Register vom Timer2
  OCR2B = round(duty_mag * time_mag / 100); // Setzen des duty cycle vom Timer2
  OCR1A = round(time_led);                   // Setzen des Output Compare Register vom Timer1
  OCR1B = round(DUTY_LED * time_led / 100); // Setzen des duty cycle vom Timer1

} 


void Set_Register() {
  // Die folgenden Zeilen richten die Timer für unsere Zwecke ein.
  // Dazu werden schnelles PWM, der Wellenformerzeugungsmodus und die Prescaler gesetzt.
  // Näheres dazu: https://www.arduino.cc/en/Tutorial/SecretsOfArduinoPWM
   
  TCCR2A = _BV(COM2A0) | _BV(COM2B1) | _BV(WGM21) | _BV(WGM20);
  TCCR2B = _BV(WGM22) | _BV(CS22)| _BV(CS21)| _BV(CS20);
  TCCR1A = _BV(COM1A0) | _BV(COM1B1) | _BV(WGM11) | _BV(WGM10); 
  TCCR1B =  _BV(WGM13) | _BV(WGM12)  |  _BV(CS11);
}



