/*
 * Make-Magazin, https://www.heise.de/make/
 * 
 * App Inventor 
 * Smartphone <-> Arduino
 * 
 * Poti A/D-Wandler -> Smartphone
 * Smartphone Helligkeit schaltet LED
 * 
 */

#include <SoftwareSerial.h>     // Software Serial, um Hardware Serial frei zu lassen

const uint8_t LED  = 13;        // eingebaute LED nutzen
const uint8_t POTI = A0;        // Poti Spannungsteiler
const uint8_t BTRX = 10;        // Rx = receive Data = Eingang am Arduino = Ausgang (Tx) des Moduls
const uint8_t BTTX = 11;        // Tx

String BT_input;                // Eingangsdaten
uint32_t zeit = millis();

SoftwareSerial SerialBT(BTRX, BTTX);    // Konstruktor

void setup()
{
  SerialBT.begin(38400);        // default baud rate HC-05
  pinMode(LED, OUTPUT);
}

void loop()
{
  if (SerialBT.available())     // Daten vorhanden?
  {
    BT_input = SerialBT.readString();   // Daten vom HC-05 lesen

    if (BT_input == "ON")
      digitalWrite(LED, HIGH);
    else if (BT_input == "OFF")
      digitalWrite(LED, LOW);
    else { }         // wenn Befehl nicht erkannt. Hier: nichts tun
  }

  if ((millis() - zeit) > 2000)           // alle 2 Sekunden...
  {
    SerialBT.print (analogRead (POTI));   // A/D-Wert einlesen und senden
    zeit = millis();               
  }
}

