/**
 *  @filename   :   epd2in13b-demo.ino
 *  @brief      :   2.13inch e-paper display (B) demo
 *  @author     :   Yehui from Waveshare
 *
 *  Copyright (C) Waveshare     July 17 2017
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documnetation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to  whom the Software is
 * furished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS OR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*
 * Make 4/2018
 * Quelle: https://www.waveshare.com/wiki/2.13inch_e-Paper_HAT_(B
 * Reduziertes Beispiel fuer zweifarbige Grafik: Info und Nichtraucher als schwarz und Make-Logo als gelb (rot)
 * Die Libraries muessen nicht in die Arduino-IDE eingebunden werden, sondern es reicht, diese hier im Ordner zu belassen.
 * Dazu wurden die Referenzierungen von <...> auf "..." geaendert
 */

#include <SPI.h>
#include "epd2in13b.h"
#include "imagedata.h"
#include "epdpaint.h"

#define COLORED     0
#define UNCOLORED   1

void setup() {
  // put your setup code here, to run once:
  Serial.begin(9600);
  Epd epd;

  if (epd.Init() != 0) {
    Serial.print("e-Paper init failed");
    return;
  }

  /* This clears the SRAM of the e-paper display */
  epd.ClearFrame();

  /**
    * Due to RAM not enough in Arduino UNO, a frame buffer is not allowed.
    * In this case, a smaller image buffer is allocated and you have to 
    * update a partial display several times.
    * 1 byte = 8 pixels, therefore you have to set 8*N pixels at a time.
    */
  unsigned char image[1024];
  Paint paint(image, 128, 18);    //width should be the multiple of 8 

  /* This displays an image */
  epd.DisplayFrame(IMAGE_BLACK, IMAGE_RED);

  paint.Clear(UNCOLORED);
  paint.DrawHorizontalLine(0, 0, 104, COLORED);
  epd.SetPartialWindowBlack(paint.GetImage(), 0, 40, paint.GetWidth(), paint.GetHeight());

  paint.Clear(UNCOLORED);
  paint.DrawStringAt(6, 2, "Konferenzraum", &Font12, COLORED);
  epd.SetPartialWindowBlack(paint.GetImage(), 0, 48, paint.GetWidth(), paint.GetHeight());
  
  paint.Clear(COLORED);
  paint.DrawStringAt(2, 1, "E239", &Font20, UNCOLORED);
  epd.SetPartialWindowBlack(paint.GetImage(), 30, 65, paint.GetWidth(), paint.GetHeight());
  
  paint.Clear(UNCOLORED);
  paint.DrawStringAt(1, 0, "Reserviert ab:", &Font12, COLORED);
  epd.SetPartialWindowRed(paint.GetImage(), 0, 95, paint.GetWidth(), paint.GetHeight());
  
  paint.SetWidth(85);
  paint.SetHeight(30);
  paint.Clear(COLORED);
  paint.DrawStringAt(0, 6, "10:45", &Font24, UNCOLORED);
  epd.SetPartialWindowRed(paint.GetImage(), 10, 110, paint.GetWidth(), paint.GetHeight());

  epd.DisplayFrame();
  /* Deep sleep */
  epd.Sleep();
}

void loop() {
  // put your main code here, to run repeatedly:

}

