/*
 * Make: 4/2018
 * Minimalistisches Beispiel zur Ansteuerung eines MAX7219 mit 8-Digit 7-Segment-LED per SPI
 */

#include <SPI.h>

const uint8_t MAX7219_CS=9;     // Chip-Select ist notwendig, einfach Dauer-LOW genügt nicht

/*
 * @brief   Sendet Daten an den MAX7219
 * @param   Adresse/Register
 *          Wert
 * @return  none
 */
void SPIoutput(byte address, byte data)
{
  digitalWrite(MAX7219_CS, LOW);    // Modul CS
  SPI.transfer(address);
  SPI.transfer(data);
  digitalWrite(MAX7219_CS, HIGH);
}

/*
 * @brief   Löscht das Display
 * @param   none
 * @return  none
 */
void MAX7219_cls ()
{
  for (uint8_t i=1; i <= 8; i++)    // alle Segmente leeren
    SPIoutput(i, 0X0F);                // blank
}

/*
 * @brief   Initialisiert den MAX7219. Einmal aufrufen
 * @param   none
 * @return  none
 */
void MAX7219_init ()
{
  SPIoutput(0x0C, 0x00);     // Shutdown-Register 0xXC, Wert 0 = Display off, 1 = Display on
  SPIoutput(0x0A, 0x0F);     // Intensity-Register 0xXA, Wert 0x00..0x0F dunkel..hell
  SPIoutput(0x09, 0xFF);     // Decode-Register 0xX9, Wert 0xFF = Zahlen auf allen Digits anzeigen, nur LSB verwenden
  SPIoutput(0x0B, 0x07);     // Scan-Limit-Register 0xXB, Wert = alle Digits darstellen
  SPIoutput(0x0C, 0x01);     // Shutdown-Register 0xXC, Wert 0 = Display off, 1 = Display on
  MAX7219_cls ();
}

void setup()
{
  SPI.begin();
  digitalWrite(MAX7219_CS, HIGH);
  pinMode(MAX7219_CS, OUTPUT);
  MAX7219_init();
}

void loop()
{
  uint8_t i, u;
  
  SPIoutput(0x0F, 0x01);     // Register-Adresse 0xXF = Display Test, Wert 0 = alle aus, 1 = alle an
  delay (500);
  SPIoutput(0x0F, 0x00);     // Register-Adresse 0xXF = Display Test, Wert 0 = alle aus, 1 = alle an
  delay (500);

  SPIoutput(0x07, 0x0A);    // -    Zeichen ausgeben
  SPIoutput(0x06, 0x0C);    // H
  SPIoutput(0x05, 0x0B);    // E
  SPIoutput(0x04, 0x0D);    // L
  SPIoutput(0x03, 0x0E);    // P
  SPIoutput(0x02, 0x0A);    // -

  for (u=1; u <= 5; u++)      // 5x blinken lassen
  {
    for (i=0; i <= 15; i++)   // dunkler werden
    {
      SPIoutput(0x0A, 15-i);     // Intensity-Register 0xXA, Wert 0x00..0x0F dunkel..hell
      delay (50);
    }
 
    for (i=0; i <= 15; i++)   // heller werden
    {
      SPIoutput(0x0A, i);     // Intensity-Register 0xXA, Wert 0x00..0x0F dunkel..hell
      delay (50);
    }
  }

  MAX7219_cls ();
  
  for (i = 0; i <= 9; i++)
  {
    SPIoutput(0x01, i);             // Position 1 (rechts) ausgeben
    SPIoutput(0x08, i | 0x80);      // Position 8 (links) + Dezimalpunkt
    delay(800);
  }

  MAX7219_cls ();
}


