// --------------------------------------------------
// --- Teeodohr 2D   CNC and/or Laser Version     ---
// --- Variant of Teeodohr from MAKE Magazin 1/17 ---
// --- Andreas Engel                              ---
// --------------------------------------------------
#include <Servo.h>
#include <pitches.h>

Servo Arm;              // Servo 1 zuweisen

// maximaler Ohr Winkel. Je nach Tassen Höhe anpassen 
int max_Winkel=60;      
int akt_Position;

// notes in the melody:
int melody_1[] = {NOTE_C4, NOTE_G3, NOTE_G3, NOTE_A3, NOTE_G3, 0, NOTE_B3, NOTE_C4};
// note durations: 4 = quarter note, 8 = eighth note, etc.:
int noteDurations_1[] = {6, 10, 10, 6, 6, 6, 6, 6};

//Mario main theme melody
int melody[] = {
  NOTE_E7, NOTE_E7, 0, NOTE_E7, 0, NOTE_C7, NOTE_E7, 0, NOTE_G7, 0, 0,  0, NOTE_G6, 0, 0, 0,
  NOTE_C7, 0, 0, NOTE_G6, 0, 0, NOTE_E6, 0, 0, NOTE_A6, 0, NOTE_B6, 0, NOTE_AS6, NOTE_A6, 0,
  NOTE_G6, NOTE_E7, NOTE_G7, NOTE_A7, 0, NOTE_F7, NOTE_G7, 0, NOTE_E7, 0, NOTE_C7, NOTE_D7, NOTE_B6, 0, 0,
  NOTE_C7, 0, 0, NOTE_G6, 0, 0, NOTE_E6, 0, 0, NOTE_A6, 0, NOTE_B6, 0, NOTE_AS6, NOTE_A6, 0,
  NOTE_G6, NOTE_E7, NOTE_G7, NOTE_A7, 0, NOTE_F7, NOTE_G7, 0, NOTE_E7, 0, NOTE_C7, NOTE_D7, NOTE_B6, 0, 0
};
//Mario main them tempo
int tempo[] = {
  12, 12, 12, 12,  12, 12, 12, 12,  12, 12, 12, 12,  12, 12, 12, 12,
  12, 12, 12, 12,  12, 12, 12, 12,  12, 12, 12, 12,  12, 12, 12, 12,
  9, 9, 9,  12, 12, 12, 12,  12, 12, 12, 12,  12, 12, 12, 12,
  12, 12, 12, 12,  12, 12, 12, 12,  12, 12, 12, 12,  12, 12, 12, 12,
  9, 9, 9,  12, 12, 12, 12,  12, 12, 12, 12,  12, 12, 12, 12,
};

int LED1=3;                 // LED 3 minuten
int LED2=5;                // LED 5 minuten
int LED3=6;               // LED 7 minuten
int speakerOut = 10;     // Piezo Lautsprecher
int Time=3;            // Time for Tea in minutes

void setup() {  

  pinMode(speakerOut, OUTPUT);
  pinMode(LED1, OUTPUT);         // LED 1
  pinMode(LED2, OUTPUT);        // LED 2
  pinMode(LED3, OUTPUT);       // LED 3
  pinMode(A1, INPUT);        // ON and minutes select switch
  pinMode(A2, INPUT);       // Start / Stop select switch

  analogWrite(LED1, 255); // 3 Minuten LED einschalten
  analogWrite(LED2, 0);   // alle anderen aus
  analogWrite(LED3, 0);   // alle anderen aus
      
  Arm.attach(11);         // attaches the servo Arm to pin D11 servo object
  akt_Position=15;
  Arm.write(akt_Position);          // tell servo 1 to go to position xx degree

  ON_OFF_Sound();         // Play Sound. Ready to make Tea
}

void loop() {

  if (analogRead(A1) > 900 ) SelectNextTime();    // Mit Taster 1 Zeit einstellen
  if (analogRead(A2) > 900 ) TeaTime() ;         // Mit Taster 2 Tea Time Starten

}
// ------------------------------------------------------------------
// ------------------------------------------------------------------
void SelectNextTime(){
  // Warten bis Taster losgelassen
  do { delay(20); }while (analogRead(A1)>500);
  
  // Zeit einstellen. 3,5,7,10 & 12 minuten
  switch (Time) {
    case 3:
      Time=5;
      analogWrite(LED1, 0);   // LED's
      analogWrite(LED2, 255);
      analogWrite(LED3, 0);
      break;
    case 5:
      Time=7;
      analogWrite(LED1, 0);   // LED's
      analogWrite(LED2, 0);
      analogWrite(LED3, 255);
      break;    
    case 7:
      Time=10;
      analogWrite(LED1, 255);   // LED's
      analogWrite(LED2, 0);
      analogWrite(LED3, 255);
      break;
    case 10:
      Time=12;
      analogWrite(LED1, 0);   // LED's
      analogWrite(LED2, 255);
      analogWrite(LED3, 255);
      break;    
    case 12:
      Time=3;
      analogWrite(LED1, 255);   // LED's
      analogWrite(LED2, 0);
      analogWrite(LED3, 0);
  }
}
// ----------------------------
void TeaTime () {
  // Warten bis Taster losgelassen
  do { delay(20); }while (analogRead(A2)>500);

  // Schleife für die Anzahl der Minuten
  for (int i = 1; i <= Time; i++){
    
    // Tee Beutel langsam abwärts bis zum eingestellten Winkel
    for (int p = 10; p <=max_Winkel; p++){
      Arm.write(p);
      delay(20);
      akt_Position=p;
    }   
    
    // Diese Schleife dauert 1minute.
    for (int x=0;x<=20;x++){
      
      // Kurz vor ende der Minute den Beutel anheben.
      if (x==20){
        for (int p = max_Winkel; p >=10; p--){
          Arm.write(p);          // tell servo 1 to go to position xx degree out of Tea slowly !!
          delay(20);
          akt_Position=p;
        }
      }
      
      // LED's fade in /out in increments of 5 points:
      for (int fadeValue = 15 ; fadeValue <= 250; fadeValue += 5) {
         analogWrite(LED1, fadeValue);
         analogWrite(LED2, 255-fadeValue);
         analogWrite(LED3, fadeValue);
        // wait for 30 milliseconds to see the dimming effect
        delay(30);
        if (analogRead(A2) > 900 ) break;             // Tea Time Stoppen
      }

      // LED's fade in / out in increments of 5 points:
      for (int fadeValue = 250 ; fadeValue >= 15; fadeValue -= 5) {
        analogWrite(LED1, fadeValue);
        analogWrite(LED2, 255-fadeValue);
        analogWrite(LED3, fadeValue);
        // wait for 30 milliseconds to see the dimming effect
        delay(30);
        if (analogRead(A2) > 900 ) break;             // Tea Time Stoppen
      }
      if (analogRead(A2) > 900 )  break;             // Tea Time Stoppen
    }
    if (analogRead(A2) > 900 ) break;             // Tea Time Stoppen
  }
  
    // Arm nach oben
    for (int p = akt_Position; p >=10; p--){
      Arm.write(p);
      delay(25);
    }
    //-- noch 2mal eintauchen
  for (int y=0; y<=1 ;y++){
    // Tee Beutel langsam abwärts bis zum eingestellten Winkel
    for (int p = 10; p <=max_Winkel; p++){
      Arm.write(p);
      delay(25);
    }   
    // Arm nach oben
    for (int p = max_Winkel; p >=15; p--){
      Arm.write(p);
      delay(25);
    }
  }

  akt_Position=15;
  Arm.write(akt_Position);

  // sing the mario tune
  sing();
  
  // Warten bis Taster losgelassen
  do { delay(20); }while (analogRead(A2)>500);

  // ON_OFF_Sound();         // Play sound ready to make Tea
  
  // Zeit wieder auf 3 min.
  Time=3;
  analogWrite(LED1, 255); // 3 Minuten LED einschalten
  analogWrite(LED2, 0);   // alle anderen aus
  analogWrite(LED3, 0);   // alle anderen aus
}
// --------------------------------------------------------------------
void ON_OFF_Sound(){
    for (int thisNote = 0; thisNote < 8; thisNote++) {
    int noteDuration_1 = 1000 / noteDurations_1[thisNote];
    tone(speakerOut, melody_1[thisNote], noteDuration_1);
    int pauseBetweenNotes = noteDuration_1 * 1.30;
    delay(pauseBetweenNotes);
    noTone(speakerOut);
  }
}

void sing() {
  // iterate over the notes of the melody:
    int size = sizeof(melody) / sizeof(int);
    for (int thisNote = 0; thisNote < size; thisNote++) {
      // to calculate the note duration, take one second
      // divided by the note type.
      //e.g. quarter note = 1000 / 4, eighth note = 1000/8, etc.
      int noteDuration = 1000 / tempo[thisNote];
      buzz(speakerOut, melody[thisNote], noteDuration);
      // to distinguish the notes, set a minimum time between them.
      // the note's duration + 30% seems to work well:
      int pauseBetweenNotes = noteDuration * 1.30;
      delay(pauseBetweenNotes);
      analogWrite(LED1, random(250));
      analogWrite(LED2, random(250));
      analogWrite(LED3, random(250));
      // stop the tone playing:
      buzz(speakerOut, 0, noteDuration);
    }
}

void buzz(int targetPin, long frequency, long length) {

  long delayValue = 1000000 / frequency / 2; // calculate the delay value between transitions
  //// 1 second's worth of microseconds, divided by the frequency, then split in half since
  //// there are two phases to each cycle
  long numCycles = frequency * length / 1000; // calculate the number of cycles for proper timing
  //// multiply frequency, which is really cycles per second, by the number of seconds to
  //// get the total number of cycles to produce
  for (long i = 0; i < numCycles; i++) { // for the calculated length of time...
    digitalWrite(targetPin, HIGH); // write the buzzer pin high to push out the diaphram
    delayMicroseconds(delayValue); // wait for the calculated delay value
    digitalWrite(targetPin, LOW); // write the buzzer pin low to pull back the diaphram
    delayMicroseconds(delayValue); // wait again or the calculated delay value
  }
}

