/*
 * Nextion-Display
 * Ansteuerungsbeispiel für Touch-Display
 * Make: 5/2018, Florian Schäffer,
 * https://www.heise.de/make/
 * 
 * Library: https://github.com/itead/ITEADLIB_Arduino_Nextion/archive/master.zip
 * Ordner umbenennen und NexConfig.h editieren
 */

#include "Nextion.h"

const uint8_t LED = 9;
uint8_t LEDON = 1;
uint32_t value = 50;     // muss 32 Bit sein

// Objekte anlegen: Page, ID, Objname
NexText Radio1Text = NexText(0, 13, "t2"); 
NexText Radio2Text = NexText(0, 14, "t3"); 
NexButton Radio1 = NexButton(0, 11, "r0");
NexButton Radio2 = NexButton(0, 12, "r1");
NexText tState = NexText(1, 6, "t0"); 
NexPicture PicOn = NexPicture(1, 3, "p1");
NexPicture PicOff = NexPicture(1, 4, "p2");
NexSlider Slider = NexSlider(1, 1, "h0");

// Eventlistener-Objekte
NexTouch *nex_listen_list[] = 
{
  &Slider,
  &PicOn,
  &PicOff,
  &Radio1,
  &Radio2,
  NULL
};

void setup() 
{
  Serial.begin(9600);  // Start serial comunication at baud=9600
  nexInit();

  // Attach Callback Functions
  Radio1.attachPop(Radio1_PopCallback, &Radio1);
  Radio2.attachPop(Radio2_PopCallback, &Radio2);

  PicOn.attachPop(PicOn_PopCallback, &PicOn);
  PicOff.attachPop(PicOff_PopCallback, &PicOff);
  Slider.attachPop(Slider_PopCallback, &Slider);

  pinMode(LED, OUTPUT); 
  analogWrite(LED, value);
}

// OFF-Button
void PicOn_PopCallback(void *ptr) 
{
  LEDON = 0;
  digitalWrite (LED, LOW);
}

// ON-Button
void PicOff_PopCallback(void *ptr) 
{
  LEDON = 1;
  analogWrite(LED, value);
}

// oberer Radio-Button gedrueckt
void Radio1_PopCallback (void *ptr) 
{
  Radio1Text.setText("German");
  Radio2Text.setText("English");
}

// unterer Radio-Button gedrueckt
void Radio2_PopCallback (void *ptr) 
{
  Radio1Text.setText("Deutsch");
  Radio2Text.setText("Englisch");
}

// Slider bewegt
void Slider_PopCallback (void *ptr)
{
  Slider.getValue(&value);
  if (LEDON)
    analogWrite(LED, value); 
}

void loop() 
{
  nexLoop(nex_listen_list);
}
