#!/usr/bin/python
# -*- coding: utf-8 -*-

#erzeugt Grafiken aus der Datei datalog.csv ausdem gleichen Verzeichnis.
from os import chdir, system 	#zum Aufruf von gnuplot und Dateilöschen
import re			#regular expressions
import calendar,time

BRENNERNENNLEISTUNG=15000.0	#Nennleistung der Therme in Watt

chdir("/home/pi/loga")
system("gnuplot genWWW.gp")
system("mv out.svg /var/www/html")

#parse log file, suche aktuelle Zeit vor 2 Stunden
logfile=open("datalog.csv","r")
lasttimestamp=0
lastbrenner=0
arbeit=0
brennerstarts=0
for zeile in logfile:
  zahlen=map(int, re.findall(r'\d+',zeile))
  if zahlen[0] >= time.time()-24*3600:
    if lasttimestamp==0:
      starttime=zahlen[0]
    else:
      arbeit+=(zahlen[0]-lasttimestamp)*lastbrenner/100.0*BRENNERNENNLEISTUNG
      if lastbrenner==0 and zahlen[6]>0:
        brennerstarts+=1
      #print zahlen[0]-lasttimestamp,lastbrenner,arbeit
      lastbrenner=zahlen[6]
    lasttimestamp=zahlen[0]
endtime=zahlen[0]      
if starttime==endtime:
  pavg=0
else:
  pavg=arbeit/(endtime-starttime)
#print pavg
speicherunten=zahlen[2]
alter=time.strftime("%H:%M:%S %Z",time.localtime(endtime))

auswertung=open("/var/www/html/index.html","w")
auswertung.write("<!DOCTYPE html><html><body><font size=\"16\">")
auswertung.write("Diagramm von {} Uhr.<br>".format(alter))
auswertung.write("Der Speicher ist unten {}&deg;C warm.<br>".format(speicherunten))
if speicherunten<50:
  auswertung.write("Bitte weiter nachlegen.<br>")
else:
  if speicherunten<60:
    auswertung.write("Bitte nur noch einmal nachlegen.<br>")
  else:
    auswertung.write("Nicht mehr nachlegen!<br>")
auswertung.write("<br>Letzte 24 Stunden:<br>")
auswertung.write("Heizleistung Gas: {:6.0f}W<br>".format(pavg))
auswertung.write("Gasvolumen: {:6.1f}m&sup3<br>".format(arbeit/3600000/10.5))
auswertung.write("Brennerstarts: {:d}<br>".format(brennerstarts))
auswertung.write("<img src=\"out.svg\" alt=\"Temperaturverlauf\" width=\"100%\"></font></body></html>")
