import network
from mqtt_writer import MQTTWriter
from umqtt.robust import MQTTClient
import json
import time
import utime
import ntptime

def connect():
    ssid = "WLAN-123"
    password =  "*************"
    station = network.WLAN(network.STA_IF)
    station.active(True)
    station.connect(ssid, password)
    time.sleep(10)
    ntptime.settime()

def connect_mqtt():
    MQTT_HOST='192.168.2.122'
    USER ='smart_home'
    PASSWORD = 'smart_ix123!'
    client = MQTTClient('esp32', MQTT_HOST, 1883, USER, PASSWORD)
    client.connect()
    return client

def scan():
    station = network.WLAN(network.STA_IF)
    return station.scan()

def get_signal():
    x = scan()
    return x[[i[0] for i in x].index(b'WLAN-123')][3]

def get_time():
    return 946684800 + utime.time()

def collect_data():
    signal = get_signal()
    timestamp = get_time()
    raum = "hier eingeben"
    return {"room" : raum, "device" : "esp32", "measurement_ts" : timestamp, "signal" : signal}

def publish_loop():
    while 1 > 0:
        data_dict = collect_data()
        data = bytes(json.dumps(data_dict), 'utf-8')
        client = connect_mqtt()
        client.publish(bytes('smart/input/1', 'utf-8'), data)
