import dtale
import pandas as pd


def main() -> None:
    # Einlesen der Materialstammdaten
    mara_file = '../data/material.csv'
    mara_df = pd.read_csv(mara_file, sep=";")

    # Einlesen der Stücklisten
    mast_file = '../data/stueckliste.csv'
    mast_df = pd.read_csv(mast_file, sep=";", usecols=['Material', 'Stueckliste'])

    # Materialdaten mit Stücklisten vereinen
    material_merge_bom_df = mara_df.merge(mast_df, how='left', left_on=['Material'], right_on=['Material'])

    # Daten anzeigen
    dtale.show(material_merge_bom_df, subprocess=False, port=40002, force=True)


if __name__ == "__main__":
    main()
