import dtale
import pandas as pd

if __name__ == "__main__":
    weather_data = "https://opendata.dwd.de/climate_environment/CDC/regional_averages_DE/annual/" \
                   "hot_days/regional_averages_txbs_year.txt"

    df = pd.read_csv(weather_data, sep=";", skiprows=1)
    df.drop(['Jahr.1', 'Thueringen/Sachsen-Anhalt', 'Unnamed: 19'], axis=1, inplace=True)

    df.rename(columns={
        'Brandenburg/Berlin': 'BE',
        'Brandenburg': 'BB',
        'Baden-Wuerttemberg': 'BW',
        'Bayern': 'BY',
        'Hessen': 'HE',
        'Mecklenburg-Vorpommern':'MV',
        'Niedersachsen': 'NI',
        'Niedersachsen/Hamburg/Bremen': 'HB-HH',
        'Nordrhein-Westfalen': 'NW',
        'Rheinland-Pfalz': 'RP',
        'Saarland': 'SL',
        'Sachsen': 'SN',
        'Sachsen-Anhalt': 'ST',
        'Schleswig-Holstein': 'SH',
        'Thueringen': 'TH',
        'Deutschland': 'DE'
    }, inplace=True)

    df = df[['Jahr', 'BB', 'BE', 'BW', 'BY', 'HB-HH', 'HE', 'MV', 'NI', 'NW', 'RP', 'SH', 'SL', 'SN', 'ST', 'TH', 'DE']]

    dtale.show(df, subprocess=False)
