import json
import jmespath
from json_schema_validator import JsonSchemaValidator


def main() -> None:
    # reading data
    with open("./data/persons.json", mode="r") as json_input:
        json_data = json.load(json_input)

    # validating against JSON schema
    json_schema_validator = JsonSchemaValidator()
    valid_data, error_message = json_schema_validator.validate_json(json_data)

    if not valid_data:
        # Program will terminate if the JSON schema validation failed.
        exit(f"JSON data NOT valid! JSON data cannot be processed! \n {error_message}")


    names = jmespath.search("persons[*].[first_name, last_name, address.street.name, address.street.number]", json_data)

    for name in names:
        person_name = f"{name[0]}_{name[1]}".lower()
        person_street = f"{name[2]} {name[3]}"

    names_json = jmespath.search("persons[*].{"
                                     "first_name: first_name, "
                                     "last_name: last_name, "
                                     "address_name: address.street.name, "
                                     "address_number: address.street.number"
                                 "}", json_data)

    for name in names_json:
        person_name = f"{name.get('first_name')}_{name.get('last_name')}".lower()
        person_street = f"{name.get('address_name')} {name.get('address_number')}"

        with open(f"./data/{person_name}.json", mode="w") as f:
            json.dump(person_street, f)


    grown_ups = jmespath.search("persons[?age > `18`].[first_name, age]", json_data)
    print(grown_ups)

    female_grown_ups = jmespath.search("persons[?age > `18` && gender == `female`]", json_data)
    print(female_grown_ups)

    div_criteria = jmespath.search("persons[?(age > `18` || address.street.number == `2`) && (gender == `female`)]", json_data)
    print(div_criteria)

    aged_33 = jmespath.search("persons[?age == `33`].{first_name: first_name, age: age}", json_data)
    print(aged_33)

    aged_33_all = jmespath.search("persons[?age == `33`]", json_data)
    print(aged_33_all)

    # key available?
    id_search = jmespath.search("persons[?id > `20`]", json_data)


if __name__ == "__main__":
    main()
