from datamodel_code_generator import generate
import importlib
from pathlib import Path
from pydantic import BaseModel


def get_model_from_schema(path_to_model: str, path_to_schema: str, schema_type: str) -> BaseModel:
    model_path = Path(path_to_model)
    model_stem = model_path.stem

    # saves the model to a file
    generate(
        input_=Path(path_to_schema),
        input_file_type=schema_type,
        output=model_path
    )

    # retrives the model from the file, importing and returning it
    return getattr(importlib.import_module(model_stem), 'Model')


def main() -> None:
    """
    Main routine: calling the model conversion method and validating data with the new Pydantic model.

    :return: Nothing
    """
    file_with_data = './data/persons.json'
    path_to_python_model_file = "persons_model_generic.py"
    path_to_json_schema_file = "./data/persons_schema.json"
    schema_type = "jsonschema"

    Model = get_model_from_schema(path_to_python_model_file, path_to_json_schema_file, schema_type)

    path = Path(file_with_data)
    all_persons = Model.parse_file(path)
    print(all_persons)


if __name__ == "__main__":
    main()
