from pathlib import Path
from persons_model import Model


def main() -> None:
    path = Path('./data/persons.json')
    all_persons = Model.parse_file(path)

    print(all_persons.persons[0].age)
    all_aged_33 = [person for person in all_persons.persons if person.age == 33]

    persons = all_persons.persons


    aged_33 = [person for person in persons if person.age == 33]
    grown_ups = [person for person in persons if person.age > 18]
    female_grown_ups = [person for person in persons if (person.age > 18 and person.gender == 'female')]
    div_criteria = [person for person in persons if (
            (person.age > 18 or person.address.street.number == 2) and person.gender == 'female')]

    for person in persons:
        print(person)
        print(person.age, person.gender)


if __name__ == "__main__":
    main()

