from pathlib import Path
from pydantic import BaseModel
from typing import List

class Street(BaseModel):
    name: str
    number: int

class City(BaseModel):
    name: str
    post_code: str

class Address(BaseModel):
    street: Street
    city: City

class Person(BaseModel):
    last_name: str
    first_name: str
    gender: str
    age: int
    address: Address

class Persons(BaseModel):
    # https://stackoverflow.com/questions/55762673/how-to-parse-list-of-models-with-pydantic
    persons: List[Person]


def main() -> None:
    # reading data
    path = Path('./data/persons.json')

    # validating against Pydantic model
    all_persons = Persons.parse_file(path) # local

    print(all_persons.persons[0].age)
    all_aged_33 = [person for person in all_persons.persons if person.age == 33]

    persons = all_persons.persons

    aged_33 = [person for person in persons if person.age == 33]
    grown_ups = [person for person in persons if person.age > 18]
    female_grown_ups = [person for person in persons if (person.age > 18 and person.gender == 'female')]
    div_criteria = [person for person in persons if (
            (person.age > 18 or person.address.street.number == 2) and person.gender == 'female')]

    try:
        no_key = [person for person in persons if person.id > 0]
    except AttributeError as ae:
        print("'Person' object has no attribute 'id'")

    for person in persons:
        print(person)
        print(person.age, person.gender)


if __name__ == "__main__":
    main()

