from genson import SchemaBuilder
import json

def main() -> None:
    """
    Routine to create a JSON schema based on a JSON data file.

    Source: https://pypi.org/project/genson/

    :return: None
    """
    builder = SchemaBuilder()

    with open('./data/persons.json', 'r') as f:
        datastore = json.load(f)
        builder.add_object(datastore)

    json_schema = builder.to_json(indent=4)

    with open("./data/persons_schema.json", "w") as schema_file:
        schema_file.write(json_schema)

    print('JSON schema created.')


if __name__ == "__main__":
    main()
