import json
from json_schema_validator import JsonSchemaValidator


def main() -> None:
    with open("./data/persons.json", mode="r") as json_input:
        # reading data
        json_data = json.load(json_input)
        persons = json_data.get('persons')

        # validating against JSON schema
        json_schema_validator = JsonSchemaValidator()
        valid_data, error_message = json_schema_validator.validate_json(json_data)

        if not valid_data:
            # Program will terminate if the JSON schema validation failed.
            exit(f"JSON data NOT valid! JSON data cannot be processed! \n {error_message}")


        for person in persons:
            person_name = f"{person['last_name']}_{person['first_name']}".lower()
            person_street = f"{person['address']['street']['name']} " \
                            f"{person['address']['street']['number']}"

            with open(f"./data/{person_name}.json", mode="w") as f:
                f.write(json.dumps(person_street))

        aged_33 = []

        for person in persons:
            if person["age"] == 33:
                aged_33.append(person)

        with open(f"./data/age_33.json", mode="w") as f_33:
            json.dump(aged_33, f_33)

        print(aged_33)


        def grown_up_filter(person) -> bool:
            if person["age"] > 20:
                return True

            return False

        grown_ups = list(filter(grown_up_filter, persons))
        print(grown_ups)

        # key available?
        if persons[0].get('id') and persons[0].get('id') > 2:
            print("key id is available")
        else:
            print("key id is NOT available")


if __name__ == "__main__":
    main()
