﻿using System;
using System.Drawing;

using MonoTouch.Foundation;
using MonoTouch.UIKit;

namespace IosCalcProg {
  public partial class IosCalcProgViewController : UIViewController {
    static bool UserInterfaceIdiomIsPhone {
      get { return UIDevice.CurrentDevice.UserInterfaceIdiom == UIUserInterfaceIdiom.Phone; }
    }

    public IosCalcProgViewController(IntPtr handle) : base(handle) {
    }

    public override void DidReceiveMemoryWarning() {
      // Releases the view if it doesn't have a superview.
      base.DidReceiveMemoryWarning();
			
      // Release any cached data, images, etc that aren't in use.
    }

    #region View lifecycle

    public override void ViewDidLoad() {
      base.ViewDidLoad();
			
      // Perform any additional setup after loading the view, typically from a nib.
    }

    public override void ViewWillAppear(bool animated) {
      base.ViewWillAppear(animated);
    }

    public override void ViewDidAppear(bool animated) {
      base.ViewDidAppear(animated);
    }

    public override void ViewWillDisappear(bool animated) {
      base.ViewWillDisappear(animated);
    }

    public override void ViewDidDisappear(bool animated) {
      base.ViewDidDisappear(animated);
    }

    #endregion

    private void calc(Char operation) {
      Double firstOperator, secondOperator;
      Double result;

      Double.TryParse(FirstNumberTextField.Text, out firstOperator);
      Double.TryParse(SecondNumberTextField.Text, out secondOperator);
      switch (operation) {
        case '+':
          result = firstOperator + secondOperator;
          break;
        case '-':
          result = firstOperator - secondOperator;
          break;
        case '*':
          result = firstOperator * secondOperator;
          break;
        default:
          result = firstOperator / secondOperator;
          break;
      }
      ResultTextField.Text = String.Format("{0}", result);
    }

    #region Event Handlers

    partial void PlusButtonTouched(UIButton sender) {
      calc('+');
    }

    partial void MinusButtonTouched(UIButton sender) {
      calc('-');
    }

    partial void MultiplyButtonTouched(UIButton sender) {
      calc('*');
    }

    partial void DivideButtonTouched(UIButton sender) {
      calc('/');
    }


    #endregion
  }
}

