package net.nieden.FileCrypter;

import java.io.*;
import java.util.*;
import javax.crypto.*;
import javax.swing.JOptionPane;

public class CFileCrypter implements IFileProgressIndicator {
	final static int OPT_BUFSZ_FLS=0, OPT_COMPRESS=1, OPT_DECRYPTION=2, OPT_ENCRYPTION=3,
		OPT_LIST=4, OPT_MULTITHREAD=5, OPT_PASSWD_FLS=6, OPT_REMOVE=7, OPT_STOREPWD=8, OPT_VERBOSE=9,
		DEFAULT_BUFSZ_KB=1024, MAX_BUFSZ_KB=32*1024;
	int opCount=0;
	BitSet bsOption=new BitSet();
	String passWord="", options="bcdelmprsv";
	ArrayList<File> fileList=new ArrayList<File>();
	long timerStart;
	int	bufSizeKB=DEFAULT_BUFSZ_KB;

	public CFileCrypter(String[] args) throws Exception {
		for (String s: args) {
			if (s.startsWith("-")&&s.length() > 1) {
				boolean b=false;
				for (int i=1;i<s.length();i++) {
					int idx=options.indexOf(s.charAt(i));
					if (idx < 0) usage(true);
					switch(idx) {
					case OPT_BUFSZ_FLS:
						if ((i+1)<s.length()) {
							bufSizeKB=Integer.parseInt(s.substring(i+1));
						} else bsOption.set(idx);
						b=true;	break;
					case OPT_PASSWD_FLS:
						if ((i+1)<s.length()) {
							passWord=s.substring(i+1);
						} else bsOption.set(idx);
						b=true;	break;
					default: bsOption.set(idx);
						break;
					}
					if (b) break;
				}
				continue;
			}
			if (bsOption.get(OPT_BUFSZ_FLS)) {
				bufSizeKB=Integer.parseInt(s);
				bsOption.clear(OPT_BUFSZ_FLS);
			} else if (bsOption.get(OPT_PASSWD_FLS)) {
				passWord=s;	bsOption.clear(OPT_PASSWD_FLS);
			} else {
				File f=new File(s);
				if (!f.isFile()) throw new Exception(s+" is not a valid filename!");
				fileList.add(f);
			}
		}
		/**
		 * Check parameters
		 */
		if (bsOption.get(OPT_ENCRYPTION)) opCount++;
		if (bsOption.get(OPT_DECRYPTION)) opCount++;
		if (bsOption.get(OPT_LIST)) opCount++;
		if (opCount!=1) {
			usage("Must specify exactly e(ncryption), d(ecryption) or l(ist) ...", true);
		}
		if (bufSizeKB < 1 || bufSizeKB>MAX_BUFSZ_KB) {
			usage("Illegal BufferSize in KB specified (Must be >= 1 <= "+MAX_BUFSZ_KB, true);
		}
		if (fileList.isEmpty()) {
			usage("Must specify at least one valid file!", true);
		}
		if (passWord.isEmpty()) {
			/**
			 * prompt for a password right now
			 */
			CPasswdReader cpReader = new CPasswdReader();
			String s=cpReader.readPasswd();
			if (s==null  || s.isEmpty()) {
				JOptionPane.showMessageDialog(null, "Empty password - exiting","Error",JOptionPane.ERROR_MESSAGE);
				System.exit(1);
			}
		}
		if (bufSizeKB!=DEFAULT_BUFSZ_KB && bsOption.get(OPT_VERBOSE))
			System.out.printf("Setting buffer Size to %d KB\n", bufSizeKB);
	}

	public void processFileList() throws Exception {
		timerStart=new Date().getTime();
		for (File f: fileList) {
			if (bsOption.get(OPT_ENCRYPTION)) {
				CFileEncrypter cfEncrypter=new CFileEncrypter(f, bufSizeKB, passWord);
				cfEncrypter.setProgressIndicator(this);
				cfEncrypter.setCompression(bsOption.get(OPT_COMPRESS));
				cfEncrypter.setMultiThreaded(bsOption.get(OPT_MULTITHREAD));
				cfEncrypter.setStorePasswd(bsOption.get(OPT_STOREPWD));
				cfEncrypter.processFile();
			} else if (bsOption.get(OPT_DECRYPTION)) {
				/**
				 * here file has to be decrypted
			 	 */
				CFileDecrypter cfDecrypter=new CFileDecrypter(f, passWord);
				cfDecrypter.processFile();
			} else { // List encrypted files
				Cipher cipher=CFileTools.initDecryption(passWord);
				CFileHeader cfHdr=new CFileHeader(new FileInputStream(f),cipher);
				System.out.println(cfHdr);
			}
			if (bsOption.get(OPT_REMOVE)) {
				f.delete();
			}
		}
		long ms=new Date().getTime()-timerStart;
		if (bsOption.get(OPT_VERBOSE) && bsOption.get(OPT_ENCRYPTION)) {
			System.out.printf("Operation completed in %02d:%02d.%03d\n",
				ms/60000, (ms%60000)/1000, ms%1000);
		}
	}

	public void usage() {
		usage(null, false);
	}

	public void usage(boolean isExit) {
		usage(null, isExit);
	}

	public void usage(String s) {
		usage(s, false);
	}

	public void usage(String s, boolean isExit) {
		if (s!=null) System.err.println(s);
		System.err.println("usage: java "+CFileCrypter.class.getName()+" -options file ...");
		System.err.println("valid options are:");
		System.err.println("\t-b Blocksize in KB [1-32.768]");
		System.err.println("\t-c = compress (GZIP) before encryption");
		System.err.println("\t-d = decrpyt");
		System.err.println("\t-e = encrypt");
		System.err.println("\t-l = list original file data");
		System.err.println("\t-m = use multithread mechanism");
		System.err.println("\t-p password (En-/Decryption salt key)");
		System.err.println("\t-r = remove Source File after processing");
		System.err.println("\t-s = store password (not recommended)");
		System.err.println("\t-v = verbose operation");
		if (isExit) System.exit(1);
	}

	public boolean progressIndicator(int num, int max) {
		return true;
	}

	public static void main(String[] args) {
		try {
			if (args.length == 0) {
				new CFileCrypterGUI();
			} else {
				CFileCrypter cc=new CFileCrypter(args);
				cc.processFileList();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
