package net.nieden.FileCrypter;

import java.io.*;
import java.util.*;
import javax.crypto.*;

public class CFileBlockProcessor {
	final static int STATUS_IDLE=1, STATUS_WORKING=2, STATUS_WAITING=3, STATUS_FINISHED=4;
	int numBlocks, maxThreads;
	boolean encrypt;
	ArrayList<blockProcThread> blockProcThreadList=new ArrayList<blockProcThread>();
	IFileProgressIndicator pgrsInidicator=null;

	public CFileBlockProcessor(int numBlocks, boolean encrypt, IFileProgressIndicator pgrsInidicator) {
		this.numBlocks=numBlocks;
		this.maxThreads=Runtime.getRuntime().availableProcessors();
		this.encrypt=encrypt;
		this.pgrsInidicator=pgrsInidicator;
		for (int i=0;i<numBlocks;i++)
			blockProcThreadList.add(new blockProcThread(i));
	}

	public int getWorkingThreadCount() {
		int count=0;
		synchronized (blockProcThreadList) {
			for (blockProcThread bpt: blockProcThreadList) {
				if (bpt.status==STATUS_WORKING)
					count++;
			}
		}
		return count;
	}

	public void waitForLastBlock() throws Exception {
		blockProcThread bpt=blockProcThreadList.get(numBlocks-1);
		for (;;) {
			if (bpt.status==STATUS_FINISHED)
				break;
			Thread.sleep(100);
		}
	}

	public class blockProcThread extends Thread {
		Integer blockID, status=STATUS_IDLE;
		byte[] inBuffer=null;
		FileOutputStream fos=null;
		boolean compress=false, is7zip=false;
		Cipher cipher;

		public blockProcThread(int blockID) {
			this.blockID=blockID;
		}

		public void startWorking(byte[] inBuffer, String passwd, FileOutputStream fos) throws Exception {
			startWorking(inBuffer,false,false,passwd,fos);
		}

		public void startWorking(byte[] inBuffer, boolean compress, String passwd, FileOutputStream fos) throws Exception {
			startWorking(inBuffer,compress,false,passwd,fos);
		}

		public void startWorking(byte[] inBuffer, boolean compress, boolean is7zip, String passwd, FileOutputStream fos) throws Exception {
			this.inBuffer=inBuffer;
			this.fos=fos;
			this.cipher=(encrypt)?CFileTools.initEncryption(passwd):CFileTools.initDecryption(passwd);
			this.compress=compress;
			this.is7zip=is7zip;
			start();
		}

		public void run() {
			try {
				synchronized(status) {
					status=STATUS_WORKING;
				}
				byte[] outBuffer=null;
				if (compress && encrypt) {
					inBuffer=CFileTools.compressBlock(inBuffer, is7zip);
				}
				outBuffer=(encrypt)?CFileTools.encryptBlock(cipher, inBuffer):CFileTools.decryptBlock(cipher, inBuffer);
				if (compress && !encrypt) {
					outBuffer=CFileTools.decompressBlock(outBuffer);
				}
				/**
				 * now as outBuffer is ready for flushing to file
				 * wait until the block with the previous blockID has been written
				 */
				synchronized(status) {
					status=STATUS_WAITING;
				}
				if (blockID>0) {
					for (;;) {
						blockProcThread bpt=blockProcThreadList.get(blockID-1);
						if (bpt.status==STATUS_FINISHED)
							break;
						Thread.sleep(10);
					}
				}
				synchronized (fos) {
					for (int i=0;i<4;i++) {
						fos.write((int)(outBuffer.length >>> ((3-i)*8))&0xff);
					}
					fos.write(outBuffer, 0, outBuffer.length);
					fos.flush();
					if (pgrsInidicator!=null) {
						pgrsInidicator.progressIndicator(blockID+1, numBlocks);
					}
				}
				synchronized(status) {
					status=STATUS_FINISHED;
				}
			} catch (Exception e) {
				System.err.println("blockProcThread.run(): terminating due to exception: "+e.getMessage());
				return;
			}
		}
	}
}
