/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.AttributeMap;
import org.apache.xerces.dom.CoreDOMImplementationImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMConfigurationImpl;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.dom.DOMLocatorImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.EntityReferenceImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.PSVIAttrNSImpl;
import org.apache.xerces.dom.PSVIElementNSImpl;
import org.apache.xerces.dom.ParentNode;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.impl.RevalidationHandler;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.util.SimpleLocator;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XML11Char;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xs.AttributePSVI;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMNormalizer
implements XMLDocumentHandler {
    protected static final boolean DEBUG_ND = false;
    protected static final boolean DEBUG = false;
    protected static final boolean DEBUG_EVENTS = false;
    protected static final String PREFIX = "NS";
    protected DOMConfigurationImpl fConfiguration = null;
    protected CoreDocumentImpl fDocument = null;
    protected final XMLAttributesProxy fAttrProxy = new XMLAttributesProxy();
    protected final QName fQName = new QName();
    protected RevalidationHandler fValidationHandler;
    protected SymbolTable fSymbolTable;
    protected DOMErrorHandler fErrorHandler;
    private final DOMErrorImpl fError = new DOMErrorImpl();
    protected boolean fNamespaceValidation = false;
    protected boolean fPSVI = false;
    protected final NamespaceContext fNamespaceContext = new NamespaceSupport();
    protected final NamespaceContext fLocalNSBinder = new NamespaceSupport();
    protected final Vector fAttributeList = new Vector(5, 10);
    protected final DOMLocatorImpl fLocator = new DOMLocatorImpl();
    protected Node fCurrentNode = null;
    private QName fAttrQName = new QName();
    final XMLString fNormalizedValue = new XMLString(new char[16], 0, 0);
    public static final RuntimeException abort = new RuntimeException();

    protected void normalizeDocument(CoreDocumentImpl coreDocumentImpl, DOMConfigurationImpl dOMConfigurationImpl) {
        this.fDocument = coreDocumentImpl;
        this.fConfiguration = dOMConfigurationImpl;
        this.fSymbolTable = (SymbolTable)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/symbol-table");
        this.fNamespaceContext.reset();
        this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
        if ((this.fConfiguration.features & 0x40) != 0) {
            this.fValidationHandler = CoreDOMImplementationImpl.singleton.getValidator("http://www.w3.org/2001/XMLSchema");
            this.fConfiguration.setFeature("http://xml.org/sax/features/validation", true);
            this.fConfiguration.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.fNamespaceValidation = true;
            this.fPSVI = (this.fConfiguration.features & 0x80) != 0;
            this.fDocument.clearIdentifiers();
            ((XMLComponent)((Object)this.fValidationHandler)).reset(this.fConfiguration);
        }
        this.fErrorHandler = (DOMErrorHandler)this.fConfiguration.getParameter("error-handler");
        if (this.fValidationHandler != null) {
            this.fValidationHandler.setDocumentHandler(this);
            this.fValidationHandler.startDocument(new SimpleLocator(this.fDocument.fDocumentURI, this.fDocument.fDocumentURI, -1, -1), this.fDocument.encoding, this.fNamespaceContext, null);
        }
        try {
            Node node = this.fDocument.getFirstChild();
            while (node != null) {
                Node node2 = node.getNextSibling();
                if ((node = this.normalizeNode(node)) != null) {
                    node2 = node;
                }
                node = node2;
            }
            if (this.fValidationHandler != null) {
                this.fValidationHandler.endDocument(null);
                CoreDOMImplementationImpl.singleton.releaseValidator("http://www.w3.org/2001/XMLSchema", this.fValidationHandler);
                this.fValidationHandler = null;
            }
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException == abort) {
                return;
            }
            throw runtimeException;
        }
    }

    protected Node normalizeNode(Node node) {
        short s = node.getNodeType();
        switch (s) {
            case 10: {
                break;
            }
            case 1: {
                Node node2;
                AttributeMap attributeMap;
                Object object;
                boolean bl;
                if ((this.fConfiguration.features & 0x100) != 0 && this.fDocument.isXMLVersionChanged() && !(bl = this.fNamespaceValidation ? CoreDocumentImpl.isValidQName(node.getPrefix(), node.getLocalName(), this.fDocument.isXML11Version()) : CoreDocumentImpl.isXMLName(node.getNodeName(), this.fDocument.isXML11Version()))) {
                    object = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Element", node.getNodeName()});
                    DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, (String)object, (short)2, null, "wf-invalid-character-in-node-name");
                }
                this.fNamespaceContext.pushContext();
                this.fLocalNSBinder.reset();
                object = (ElementImpl)node;
                if (((NodeImpl)object).needsSyncChildren()) {
                    ((ParentNode)object).synchronizeChildren();
                }
                AttributeMap attributeMap2 = attributeMap = ((ElementImpl)object).hasAttributes() ? (AttributeMap)((ElementImpl)object).getAttributes() : null;
                if ((this.fConfiguration.features & 1) != 0) {
                    this.namespaceFixUp((ElementImpl)object, attributeMap);
                } else if (attributeMap != null) {
                    int n = 0;
                    while (n < attributeMap.getLength()) {
                        node2 = (Attr)attributeMap.item(n);
                        node2.normalize();
                        if ((this.fConfiguration.features & 0x100) != 0) {
                            DOMNormalizer.isAttrValueWF(this.fErrorHandler, this.fError, this.fLocator, attributeMap, (AttrImpl)node2, node2.getValue(), this.fDocument.isXML11Version());
                            if (this.fDocument.isXMLVersionChanged() && !(bl = CoreDocumentImpl.isXMLName(node.getNodeName(), this.fDocument.isXML11Version()))) {
                                String string = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Attr", node.getNodeName()});
                                DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, string, (short)2, null, "wf-invalid-character-in-node-name");
                            }
                        }
                        ++n;
                    }
                }
                if (this.fValidationHandler != null) {
                    this.fAttrProxy.setAttributes(attributeMap, this.fDocument, (ElementImpl)object);
                    this.updateQName((Node)object, this.fQName);
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                    this.fCurrentNode = node;
                    this.fValidationHandler.startElement(this.fQName, this.fAttrProxy, null);
                }
                Node node3 = ((ParentNode)object).getFirstChild();
                while (node3 != null) {
                    node2 = node3.getNextSibling();
                    if ((node3 = this.normalizeNode(node3)) != null) {
                        node2 = node3;
                    }
                    node3 = node2;
                }
                if (this.fValidationHandler != null) {
                    this.updateQName((Node)object, this.fQName);
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                    this.fCurrentNode = node;
                    this.fValidationHandler.endElement(this.fQName, null);
                }
                this.fNamespaceContext.popContext();
                break;
            }
            case 8: {
                if ((this.fConfiguration.features & 0x20) == 0) {
                    Node node4;
                    Node node5 = node.getPreviousSibling();
                    Node node6 = node.getParentNode();
                    node6.removeChild(node);
                    if (node5 == null || node5.getNodeType() != 3 || (node4 = node5.getNextSibling()) == null || node4.getNodeType() != 3) break;
                    ((TextImpl)node4).insertData(0, node5.getNodeValue());
                    node6.removeChild(node5);
                    return node4;
                }
                if ((this.fConfiguration.features & 0x100) == 0) break;
                String string = ((Comment)node).getData();
                DOMNormalizer.isCommentWF(this.fErrorHandler, this.fError, this.fLocator, string, this.fDocument.isXML11Version());
                break;
            }
            case 5: {
                if ((this.fConfiguration.features & 4) == 0) {
                    Node node7;
                    Node node8 = node.getPreviousSibling();
                    Node node9 = node.getParentNode();
                    ((EntityReferenceImpl)node).setReadOnly(false, true);
                    this.expandEntityRef(node9, node);
                    node9.removeChild(node);
                    Node node10 = node7 = node8 != null ? node8.getNextSibling() : node9.getFirstChild();
                    if (node8 != null && node8.getNodeType() == 3 && node7.getNodeType() == 3) {
                        return node8;
                    }
                    return node7;
                }
                if ((this.fConfiguration.features & 0x100) == 0 || !this.fDocument.isXMLVersionChanged()) break;
                CoreDocumentImpl.isXMLName(node.getNodeName(), this.fDocument.isXML11Version());
                break;
            }
            case 4: {
                if ((this.fConfiguration.features & 8) == 0) {
                    Node node11 = node.getPreviousSibling();
                    if (node11 != null && node11.getNodeType() == 3) {
                        ((Text)node11).appendData(node.getNodeValue());
                        node.getParentNode().removeChild(node);
                        return node11;
                    }
                    Text text = this.fDocument.createTextNode(node.getNodeValue());
                    Node node12 = node.getParentNode();
                    node = node12.replaceChild(text, node);
                    return text;
                }
                if (this.fValidationHandler != null) {
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                    this.fCurrentNode = node;
                    this.fValidationHandler.startCDATA(null);
                    this.fValidationHandler.characterData(node.getNodeValue(), null);
                    this.fValidationHandler.endCDATA(null);
                }
                String string = node.getNodeValue();
                if ((this.fConfiguration.features & 0x10) != 0) {
                    int n;
                    Node node13 = node.getParentNode();
                    DOMNormalizer.isXMLCharWF(this.fErrorHandler, this.fError, this.fLocator, node.getNodeValue(), this.fDocument.isXML11Version());
                    while ((n = string.indexOf("]]>")) >= 0) {
                        node.setNodeValue(string.substring(0, n + 2));
                        string = string.substring(n + 2);
                        CDATASection cDATASection = this.fDocument.createCDATASection(string);
                        node13.insertBefore(cDATASection, node.getNextSibling());
                        node = cDATASection;
                        String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "cdata-sections-splitted", new Object[]{"Attr", node.getNodeName()});
                        DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, string2, (short)1, node, "cdata-sections-splitted");
                    }
                    break;
                }
                DOMNormalizer.isCDataWF(this.fErrorHandler, this.fError, this.fLocator, string, this.fDocument.isXML11Version());
                break;
            }
            case 3: {
                int n;
                Node node14 = node.getNextSibling();
                if (node14 != null && node14.getNodeType() == 3) {
                    ((Text)node).appendData(node14.getNodeValue());
                    node.getParentNode().removeChild(node14);
                    return node;
                }
                if (node.getNodeValue().length() == 0) {
                    node.getParentNode().removeChild(node);
                    break;
                }
                int n2 = n = node14 != null ? (int)node14.getNodeType() : -1;
                if (n != -1 && ((this.fConfiguration.features & 4) == 0 && n == 6 || (this.fConfiguration.features & 0x20) == 0 && n == 8 || (this.fConfiguration.features & 8) == 0 && n == 4)) break;
                if ((this.fConfiguration.features & 0x100) != 0) {
                    DOMNormalizer.isXMLCharWF(this.fErrorHandler, this.fError, this.fLocator, node.getNodeValue(), this.fDocument.isXML11Version());
                }
                if (this.fValidationHandler == null) break;
                this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                this.fCurrentNode = node;
                this.fValidationHandler.characterData(node.getNodeValue(), null);
                break;
            }
            case 7: {
                if ((this.fConfiguration.features & 0x100) == 0) break;
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                String string = processingInstruction.getTarget();
                boolean bl = this.fDocument.isXML11Version() ? XML11Char.isXML11ValidName(string) : XMLChar.isValidName(string);
                if (!bl) {
                    String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Element", node.getNodeName()});
                    DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, string3, (short)2, null, "wf-invalid-character-in-node-name");
                }
                DOMNormalizer.isXMLCharWF(this.fErrorHandler, this.fError, this.fLocator, processingInstruction.getData(), this.fDocument.isXML11Version());
            }
        }
        return null;
    }

    protected final void expandEntityRef(Node node, Node node2) {
        Node node3 = node2.getFirstChild();
        while (node3 != null) {
            Node node4 = node3.getNextSibling();
            node.insertBefore(node3, node2);
            node3 = node4;
        }
    }

    protected final void namespaceFixUp(ElementImpl elementImpl, AttributeMap attributeMap) {
        String string;
        String string2;
        String string3;
        String string4;
        Attr attr;
        if (attributeMap != null) {
            int n = 0;
            while (n < attributeMap.getLength()) {
                attr = (Attr)attributeMap.getItem(n);
                if ((this.fConfiguration.features & 0x100) != 0 && this.fDocument.isXMLVersionChanged()) {
                    this.fDocument.checkQName(attr.getPrefix(), attr.getLocalName());
                }
                if ((string4 = attr.getNamespaceURI()) != null && string4.equals(NamespaceContext.XMLNS_URI)) {
                    string3 = attr.getNodeValue();
                    if (string3 == null) {
                        string3 = XMLSymbols.EMPTY_STRING;
                    }
                    if (string3.equals(NamespaceContext.XMLNS_URI)) {
                        string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "CantBindXMLNS", null);
                        DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, string2, (short)2, attr, "CantBindXMLNS");
                    } else {
                        string = attr.getPrefix();
                        string = string == null || string.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string);
                        string2 = this.fSymbolTable.addSymbol(attr.getLocalName());
                        if (string == XMLSymbols.PREFIX_XMLNS) {
                            if ((string3 = this.fSymbolTable.addSymbol(string3)).length() != 0) {
                                this.fNamespaceContext.declarePrefix(string2, string3);
                            }
                        } else {
                            string3 = this.fSymbolTable.addSymbol(string3);
                            this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, string3);
                        }
                    }
                }
                ++n;
            }
        }
        string4 = elementImpl.getNamespaceURI();
        string = elementImpl.getPrefix();
        if (string4 != null) {
            string4 = this.fSymbolTable.addSymbol(string4);
            String string5 = string = string == null || string.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string);
            if (this.fNamespaceContext.getURI(string) != string4) {
                this.addNamespaceDecl(string, string4, elementImpl);
                this.fLocalNSBinder.declarePrefix(string, string4);
                this.fNamespaceContext.declarePrefix(string, string4);
            }
        } else if (elementImpl.getLocalName() == null) {
            if (this.fNamespaceValidation) {
                String string6 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NullLocalElementName", new Object[]{elementImpl.getNodeName()});
                DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, string6, (short)3, null, "NullLocalElementName");
            } else {
                String string7 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NullLocalElementName", new Object[]{elementImpl.getNodeName()});
                DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, string7, (short)2, null, "NullLocalElementName");
            }
        } else {
            string4 = this.fNamespaceContext.getURI(XMLSymbols.EMPTY_STRING);
            if (string4 != null && string4.length() > 0) {
                this.addNamespaceDecl(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING, elementImpl);
                this.fLocalNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
            }
        }
        if (attributeMap != null) {
            attributeMap.cloneMap(this.fAttributeList);
            int n = 0;
            while (n < this.fAttributeList.size()) {
                attr = (Attr)this.fAttributeList.elementAt(n);
                attr.normalize();
                string3 = attr.getValue();
                String string8 = attr.getNodeName();
                string4 = attr.getNamespaceURI();
                if (string3 == null) {
                    string3 = XMLSymbols.EMPTY_STRING;
                }
                if (string4 != null) {
                    string = attr.getPrefix();
                    string = string == null || string.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string);
                    this.fSymbolTable.addSymbol(attr.getLocalName());
                    if (string4 == null || !string4.equals(NamespaceContext.XMLNS_URI)) {
                        String string9;
                        if ((this.fConfiguration.features & 0x100) != 0) {
                            boolean bl;
                            DOMNormalizer.isAttrValueWF(this.fErrorHandler, this.fError, this.fLocator, attributeMap, (AttrImpl)attr, attr.getValue(), this.fDocument.isXML11Version());
                            if (this.fDocument.isXMLVersionChanged() && !(bl = CoreDocumentImpl.isXMLName(attr.getNodeName(), this.fDocument.isXML11Version()))) {
                                string9 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Attribute", attr.getNodeName()});
                                DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, string9, (short)2, null, "wf-invalid-character-in-node-name");
                            }
                        }
                        ((AttrImpl)attr).setIdAttribute(false);
                        string4 = this.fSymbolTable.addSymbol(string4);
                        string2 = this.fNamespaceContext.getURI(string);
                        if (string == XMLSymbols.EMPTY_STRING || string2 != string4) {
                            string8 = attr.getNodeName();
                            string9 = this.fNamespaceContext.getPrefix(string4);
                            if (string9 != null && string9 != XMLSymbols.EMPTY_STRING) {
                                string = string9;
                            } else {
                                if (string == XMLSymbols.EMPTY_STRING || this.fLocalNSBinder.getURI(string) != null) {
                                    int n2 = 1;
                                    string = this.fSymbolTable.addSymbol(PREFIX + n2++);
                                    while (this.fLocalNSBinder.getURI(string) != null) {
                                        string = this.fSymbolTable.addSymbol(PREFIX + n2++);
                                    }
                                }
                                this.addNamespaceDecl(string, string4, elementImpl);
                                string3 = this.fSymbolTable.addSymbol(string3);
                                this.fLocalNSBinder.declarePrefix(string, string3);
                                this.fNamespaceContext.declarePrefix(string, string4);
                            }
                            attr.setPrefix(string);
                        }
                    }
                } else {
                    ((AttrImpl)attr).setIdAttribute(false);
                    if (attr.getLocalName() == null) {
                        if (this.fNamespaceValidation) {
                            string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NullLocalAttrName", new Object[]{attr.getNodeName()});
                            DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, string2, (short)3, null, "NullLocalAttrName");
                        } else {
                            string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NullLocalAttrName", new Object[]{attr.getNodeName()});
                            DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, string2, (short)2, null, "NullLocalAttrName");
                        }
                    }
                }
                ++n;
            }
        }
    }

    protected final void addNamespaceDecl(String string, String string2, ElementImpl elementImpl) {
        if (string == XMLSymbols.EMPTY_STRING) {
            elementImpl.setAttributeNS(NamespaceContext.XMLNS_URI, XMLSymbols.PREFIX_XMLNS, string2);
        } else {
            elementImpl.setAttributeNS(NamespaceContext.XMLNS_URI, "xmlns:" + string, string2);
        }
    }

    public static final void isCDataWF(DOMErrorHandler dOMErrorHandler, DOMErrorImpl dOMErrorImpl, DOMLocatorImpl dOMLocatorImpl, String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        if (bl) {
            int n2 = 0;
            while (n2 < n) {
                int n3;
                char c;
                if (XML11Char.isXML11Invalid(c = cArray[n2++])) {
                    String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInCDSect", new Object[]{Integer.toString(c, 16)});
                    DOMNormalizer.reportDOMError(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, string2, (short)2, null, "wf-invalid-character");
                    continue;
                }
                if (c != ']' || (n3 = n2) >= n || cArray[n3] != ']') continue;
                while (++n3 < n && cArray[n3] == ']') {
                }
                if (n3 >= n || cArray[n3] != '>') continue;
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "CDEndInContent", null);
                DOMNormalizer.reportDOMError(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, string3, (short)2, null, "wf-invalid-character");
            }
        } else {
            int n4 = 0;
            while (n4 < n) {
                int n5;
                char c;
                if (XMLChar.isInvalid(c = cArray[n4++])) {
                    String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInCDSect", new Object[]{Integer.toString(c, 16)});
                    DOMNormalizer.reportDOMError(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, string4, (short)2, null, "wf-invalid-character");
                    continue;
                }
                if (c != ']' || (n5 = n4) >= n || cArray[n5] != ']') continue;
                while (++n5 < n && cArray[n5] == ']') {
                }
                if (n5 >= n || cArray[n5] != '>') continue;
                String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "CDEndInContent", null);
                DOMNormalizer.reportDOMError(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, string5, (short)2, null, "wf-invalid-character");
            }
        }
    }

    public static final void isXMLCharWF(DOMErrorHandler dOMErrorHandler, DOMErrorImpl dOMErrorImpl, DOMLocatorImpl dOMLocatorImpl, String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        if (bl) {
            int n2 = 0;
            while (n2 < n) {
                if (!XML11Char.isXML11Invalid(cArray[n2++])) continue;
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "InvalidXMLCharInDOM", new Object[]{Integer.toString(cArray[n2 - 1], 16)});
                DOMNormalizer.reportDOMError(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, string2, (short)2, null, "wf-invalid-character");
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                if (!XMLChar.isInvalid(cArray[n3++])) continue;
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "InvalidXMLCharInDOM", new Object[]{Integer.toString(cArray[n3 - 1], 16)});
                DOMNormalizer.reportDOMError(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, string3, (short)2, null, "wf-invalid-character");
            }
        }
    }

    public static final void isCommentWF(DOMErrorHandler dOMErrorHandler, DOMErrorImpl dOMErrorImpl, DOMLocatorImpl dOMLocatorImpl, String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        if (bl) {
            int n2 = 0;
            while (n2 < n) {
                String string2;
                char c;
                if (XML11Char.isXML11Invalid(c = cArray[n2++])) {
                    string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInComment", new Object[]{Integer.toString(cArray[n2 - 1], 16)});
                    DOMNormalizer.reportDOMError(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, string2, (short)2, null, "wf-invalid-character");
                    continue;
                }
                if (c != '-' || n2 >= n || cArray[n2] != '-') continue;
                string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "DashDashInComment", null);
                DOMNormalizer.reportDOMError(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, string2, (short)2, null, "wf-invalid-character");
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                String string3;
                char c;
                if (XMLChar.isInvalid(c = cArray[n3++])) {
                    string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInComment", new Object[]{Integer.toString(cArray[n3 - 1], 16)});
                    DOMNormalizer.reportDOMError(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, string3, (short)2, null, "wf-invalid-character");
                    continue;
                }
                if (c != '-' || n3 >= n || cArray[n3] != '-') continue;
                string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "DashDashInComment", null);
                DOMNormalizer.reportDOMError(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, string3, (short)2, null, "wf-invalid-character");
            }
        }
    }

    public static final void isAttrValueWF(DOMErrorHandler dOMErrorHandler, DOMErrorImpl dOMErrorImpl, DOMLocatorImpl dOMLocatorImpl, AttributeMap attributeMap, AttrImpl attrImpl, String string, boolean bl) {
        if (attrImpl.hasStringValue()) {
            DOMNormalizer.isXMLCharWF(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, string, bl);
        } else {
            NodeList nodeList = attrImpl.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node.getNodeType() == 5) {
                    Object object;
                    Document document = attrImpl.getOwnerDocument();
                    Entity entity = null;
                    if (document != null && (object = document.getDoctype()) != null) {
                        NamedNodeMap namedNodeMap = object.getEntities();
                        entity = (Entity)namedNodeMap.getNamedItemNS("*", node.getNodeName());
                    }
                    if (entity == null) {
                        object = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "UndeclaredEntRefInAttrValue", new Object[]{attrImpl.getNodeName()});
                        DOMNormalizer.reportDOMError(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, (String)object, (short)2, null, "UndeclaredEntRefInAttrValue");
                    }
                } else {
                    DOMNormalizer.isXMLCharWF(dOMErrorHandler, dOMErrorImpl, dOMLocatorImpl, node.getNodeValue(), bl);
                }
                ++n;
            }
        }
    }

    public static final void reportDOMError(DOMErrorHandler dOMErrorHandler, DOMErrorImpl dOMErrorImpl, DOMLocatorImpl dOMLocatorImpl, String string, short s, Node node, String string2) {
        if (dOMErrorHandler != null) {
            dOMErrorImpl.reset();
            dOMErrorImpl.fMessage = string;
            dOMErrorImpl.fSeverity = s;
            dOMErrorImpl.fLocator = dOMLocatorImpl;
            dOMErrorImpl.fType = string2;
            dOMLocatorImpl.fRelatedNode = node;
            if (!dOMErrorHandler.handleError(dOMErrorImpl)) {
                throw abort;
            }
        }
        if (s == 3) {
            throw abort;
        }
    }

    protected final void updateQName(Node node, QName qName) {
        String string = node.getPrefix();
        String string2 = node.getNamespaceURI();
        String string3 = node.getLocalName();
        qName.prefix = string != null && string.length() != 0 ? this.fSymbolTable.addSymbol(string) : null;
        qName.localpart = string3 != null ? this.fSymbolTable.addSymbol(string3) : null;
        qName.rawname = this.fSymbolTable.addSymbol(node.getNodeName());
        qName.uri = string2 != null ? this.fSymbolTable.addSymbol(string2) : null;
    }

    final String normalizeAttributeValue(String string, Attr attr) {
        if (!attr.getSpecified()) {
            return string;
        }
        int n = string.length();
        if (this.fNormalizedValue.ch.length < n) {
            this.fNormalizedValue.ch = new char[n];
        }
        this.fNormalizedValue.length = 0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\t' || c == '\n') {
                this.fNormalizedValue.ch[this.fNormalizedValue.length++] = 32;
                bl = true;
            } else if (c == '\r') {
                bl = true;
                this.fNormalizedValue.ch[this.fNormalizedValue.length++] = 32;
                int n3 = n2 + 1;
                if (n3 < n && string.charAt(n3) == '\n') {
                    n2 = n3;
                }
            } else {
                this.fNormalizedValue.ch[this.fNormalizedValue.length++] = c;
            }
            ++n2;
        }
        if (bl) {
            string = this.fNormalizedValue.toString();
            attr.setValue(string);
        }
        return string;
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        Element element = (Element)this.fCurrentNode;
        int n = xMLAttributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            xMLAttributes.getName(n2, this.fAttrQName);
            Attr attr = null;
            attr = element.getAttributeNodeNS(this.fAttrQName.uri, this.fAttrQName.localpart);
            AttributePSVI attributePSVI = (AttributePSVI)xMLAttributes.getAugmentations(n2).getItem("ATTRIBUTE_PSVI");
            if (attributePSVI != null) {
                XSTypeDefinition xSTypeDefinition = attributePSVI.getMemberTypeDefinition();
                boolean bl = false;
                if (xSTypeDefinition != null) {
                    bl = ((XSSimpleType)xSTypeDefinition).isIDType();
                } else {
                    xSTypeDefinition = attributePSVI.getTypeDefinition();
                    if (xSTypeDefinition != null) {
                        bl = ((XSSimpleType)xSTypeDefinition).isIDType();
                    }
                }
                if (bl) {
                    ((ElementImpl)element).setIdAttributeNode(attr, true);
                }
                if (this.fPSVI) {
                    ((PSVIAttrNSImpl)attr).setPSVI(attributePSVI);
                }
                if ((this.fConfiguration.features & 2) != 0) {
                    boolean bl2 = attr.getSpecified();
                    attr.setValue(attributePSVI.getSchemaNormalizedValue());
                    if (!bl2) {
                        ((AttrImpl)attr).setSpecified(bl2);
                    }
                }
            }
            ++n2;
        }
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.startElement(qName, xMLAttributes, augmentations);
        this.endElement(qName, augmentations);
    }

    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
    }

    public void textDecl(String string, String string2, Augmentations augmentations) throws XNIException {
    }

    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        ElementPSVI elementPSVI = (ElementPSVI)augmentations.getItem("ELEMENT_PSVI");
        if (elementPSVI != null) {
            ElementImpl elementImpl = (ElementImpl)this.fCurrentNode;
            if (this.fPSVI) {
                ((PSVIElementNSImpl)this.fCurrentNode).setPSVI(elementPSVI);
            }
            String string = elementPSVI.getSchemaNormalizedValue();
            if ((this.fConfiguration.features & 2) != 0) {
                if (string != null) {
                    elementImpl.setTextContent(string);
                }
            } else {
                String string2 = elementImpl.getTextContent();
                if (string2.length() == 0 && string != null) {
                    elementImpl.setTextContent(string);
                }
            }
        }
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
    }

    public void setDocumentSource(XMLDocumentSource xMLDocumentSource) {
    }

    public XMLDocumentSource getDocumentSource() {
        return null;
    }

    protected final class XMLAttributesProxy
    implements XMLAttributes {
        protected AttributeMap fAttributes;
        protected CoreDocumentImpl fDocument;
        protected ElementImpl fElement;
        protected final Vector fAugmentations = new Vector(5);

        protected XMLAttributesProxy() {
        }

        public void setAttributes(AttributeMap attributeMap, CoreDocumentImpl coreDocumentImpl, ElementImpl elementImpl) {
            this.fDocument = coreDocumentImpl;
            this.fAttributes = attributeMap;
            this.fElement = elementImpl;
            if (attributeMap != null) {
                int n = attributeMap.getLength();
                this.fAugmentations.setSize(n);
                int n2 = 0;
                while (n2 < n) {
                    this.fAugmentations.setElementAt(new AugmentationsImpl(), n2);
                    ++n2;
                }
            } else {
                this.fAugmentations.setSize(0);
            }
        }

        public int addAttribute(QName qName, String string, String string2) {
            int n = this.fElement.getXercesAttribute(qName.uri, qName.localpart);
            if (n < 0) {
                AttrImpl attrImpl = (AttrImpl)((CoreDocumentImpl)this.fElement.getOwnerDocument()).createAttributeNS(qName.uri, qName.rawname, qName.localpart);
                n = this.fElement.setXercesAttributeNode(attrImpl);
                attrImpl.setNodeValue(string2);
                this.fAugmentations.insertElementAt(new AugmentationsImpl(), n);
                attrImpl.setSpecified(false);
            }
            return n;
        }

        public void removeAllAttributes() {
        }

        public void removeAttributeAt(int n) {
        }

        public int getLength() {
            return this.fAttributes != null ? this.fAttributes.getLength() : 0;
        }

        public int getIndex(String string) {
            return -1;
        }

        public int getIndex(String string, String string2) {
            return -1;
        }

        public void setName(int n, QName qName) {
        }

        public void getName(int n, QName qName) {
            if (this.fAttributes != null) {
                DOMNormalizer.this.updateQName((Node)this.fAttributes.getItem(n), qName);
            }
        }

        public String getPrefix(int n) {
            return null;
        }

        public String getURI(int n) {
            return null;
        }

        public String getLocalName(int n) {
            return null;
        }

        public String getQName(int n) {
            return null;
        }

        public void setType(int n, String string) {
        }

        public String getType(int n) {
            return "CDATA";
        }

        public String getType(String string) {
            return "CDATA";
        }

        public String getType(String string, String string2) {
            return "CDATA";
        }

        public void setValue(int n, String string) {
            if (this.fAttributes != null) {
                AttrImpl attrImpl = (AttrImpl)this.fAttributes.getItem(n);
                boolean bl = attrImpl.getSpecified();
                attrImpl.setValue(string);
                attrImpl.setSpecified(bl);
            }
        }

        public String getValue(int n) {
            return this.fAttributes != null ? this.fAttributes.item(n).getNodeValue() : "";
        }

        public String getValue(String string) {
            return null;
        }

        public String getValue(String string, String string2) {
            if (this.fAttributes != null) {
                Node node = this.fAttributes.getNamedItemNS(string, string2);
                return node != null ? node.getNodeValue() : null;
            }
            return null;
        }

        public void setNonNormalizedValue(int n, String string) {
        }

        public String getNonNormalizedValue(int n) {
            return null;
        }

        public void setSpecified(int n, boolean bl) {
            AttrImpl attrImpl = (AttrImpl)this.fAttributes.getItem(n);
            attrImpl.setSpecified(bl);
        }

        public boolean isSpecified(int n) {
            return ((Attr)this.fAttributes.getItem(n)).getSpecified();
        }

        public Augmentations getAugmentations(int n) {
            return (Augmentations)this.fAugmentations.elementAt(n);
        }

        public Augmentations getAugmentations(String string, String string2) {
            return null;
        }

        public Augmentations getAugmentations(String string) {
            return null;
        }

        public void setAugmentations(int n, Augmentations augmentations) {
            this.fAugmentations.setElementAt(augmentations, n);
        }
    }
}

